/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction.pagination;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.exceptions.ParsingException;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.PaginationAction;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.PollVotersPaginationAction;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.UserImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.pagination.PaginationActionImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;

public class PollVotersPaginationActionImpl
extends PaginationActionImpl<User, PollVotersPaginationAction>
implements PollVotersPaginationAction {
    public PollVotersPaginationActionImpl(JDA jda, String channelId, String messageId, long answerId) {
        super(jda, Route.Messages.GET_POLL_ANSWER_VOTERS.compile(channelId, messageId, Long.toString(answerId)), 1, 100, 100);
        this.order = PaginationAction.PaginationOrder.FORWARD;
    }

    @Override
    @Nonnull
    public EnumSet<PaginationAction.PaginationOrder> getSupportedOrders() {
        return EnumSet.of(PaginationAction.PaginationOrder.FORWARD);
    }

    @Override
    protected long getKey(User it) {
        return it.getIdLong();
    }

    @Override
    protected void handleSuccess(Response response, Request<List<User>> request) {
        DataArray array = response.getObject().getArray("users");
        ArrayList<UserImpl> users = new ArrayList<UserImpl>(array.length());
        EntityBuilder builder = this.api.getEntityBuilder();
        for (int i = 0; i < array.length(); ++i) {
            try {
                DataObject object = array.getObject(i);
                users.add(builder.createUser(object));
                continue;
            }
            catch (ParsingException | NullPointerException e) {
                LOG.warn("Encountered an exception in PollVotersPaginationAction", e);
            }
        }
        if (!users.isEmpty()) {
            if (this.useCache) {
                this.cached.addAll(users);
            }
            this.last = users.get(users.size() - 1);
            this.lastKey = ((User)this.last).getIdLong();
        }
        request.onSuccess(users);
    }
}

