/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction.pagination;

import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.PaginationAction;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.PinnedMessagePaginationAction;
import de.staffchat.shaded.jda.api.utils.TimeUtil;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.ReceivedMessage;
import de.staffchat.shaded.jda.internal.requests.restaction.pagination.PaginationActionImpl;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;

public class PinnedMessagePaginationActionImpl
extends PaginationActionImpl<PinnedMessagePaginationAction.PinnedMessage, PinnedMessagePaginationAction>
implements PinnedMessagePaginationAction {
    protected final MessageChannel channel;

    public PinnedMessagePaginationActionImpl(MessageChannel channel) {
        super(channel.getJDA(), Route.Messages.GET_MESSAGE_PINS.compile(channel.getId()), 1, 50, 50);
        this.channel = channel;
    }

    @Override
    @Nonnull
    public EnumSet<PaginationAction.PaginationOrder> getSupportedOrders() {
        return EnumSet.of(PaginationAction.PaginationOrder.BACKWARD);
    }

    @Override
    protected long getKey(PinnedMessagePaginationAction.PinnedMessage it) {
        OffsetDateTime timestamp = it.getTimePinned();
        long epochMillis = timestamp.toInstant().toEpochMilli();
        return TimeUtil.getDiscordTimestamp(epochMillis);
    }

    @Override
    @Nonnull
    protected String getPaginationLastEvaluatedKey(long lastId, PinnedMessagePaginationAction.PinnedMessage last) {
        if (last == null) {
            return OffsetDateTime.now(ZoneOffset.UTC).toString();
        }
        return last.getTimePinned().toString();
    }

    @Override
    protected void handleSuccess(Response response, Request<List<PinnedMessagePaginationAction.PinnedMessage>> request) {
        DataObject object = response.getObject();
        DataArray items = object.getArray("items");
        EntityBuilder entityBuilder = this.api.getEntityBuilder();
        ArrayList<PinnedMessagePaginationAction.PinnedMessage> messages = new ArrayList<PinnedMessagePaginationAction.PinnedMessage>(items.length());
        for (int i = 0; i < items.length(); ++i) {
            try {
                DataObject item = items.getObject(i);
                ReceivedMessage message = entityBuilder.createMessageWithChannel(item.getObject("message"), this.channel, false);
                OffsetDateTime pinnedAt = item.getOffsetDateTime("pinned_at");
                PinnedMessagePaginationAction.PinnedMessage pinnedMessage = new PinnedMessagePaginationAction.PinnedMessage(pinnedAt, message);
                messages.add(pinnedMessage);
                this.last = pinnedMessage;
                this.lastKey = this.getKey((PinnedMessagePaginationAction.PinnedMessage)this.last);
                if (!this.useCache) continue;
                this.cached.add(pinnedMessage);
                continue;
            }
            catch (Exception e) {
                EntityBuilder.LOG.error("Failed to parse pinned message", e);
            }
        }
        request.onSuccess(messages);
    }
}

