/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.WebhookMessageEditAction;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.api.utils.messages.MessageEditBuilder;
import de.staffchat.shaded.jda.api.utils.messages.MessageEditData;
import de.staffchat.shaded.jda.internal.requests.restaction.AbstractWebhookMessageActionImpl;
import de.staffchat.shaded.jda.internal.utils.message.MessageEditBuilderMixin;
import java.util.function.Function;
import okhttp3.RequestBody;

public class WebhookMessageEditActionImpl<T>
extends AbstractWebhookMessageActionImpl<T, WebhookMessageEditActionImpl<T>>
implements WebhookMessageEditAction<T>,
MessageEditBuilderMixin<WebhookMessageEditAction<T>> {
    private final Function<DataObject, T> transformer;
    private final MessageEditBuilder builder = new MessageEditBuilder();

    public WebhookMessageEditActionImpl(JDA api, Route.CompiledRoute route, Function<DataObject, T> transformer) {
        super(api, route);
        this.transformer = transformer;
    }

    @Override
    public MessageEditBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected RequestBody finalizeData() {
        try (MessageEditData data = this.builder.build();){
            DataObject payload = data.toData();
            RequestBody requestBody = this.getMultipartBody(data.getAllDistinctFiles(), payload);
            return requestBody;
        }
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        if (this.threadId != null) {
            route = route.withQueryParams("thread_id", this.threadId);
        }
        return route;
    }

    @Override
    protected void handleSuccess(Response response, Request<T> request) {
        T message = this.transformer.apply(response.getObject());
        request.onSuccess(message);
    }
}

