/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction;

import de.staffchat.shaded.jda.api.entities.StageInstance;
import de.staffchat.shaded.jda.api.entities.channel.concrete.StageChannel;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.StageInstanceAction;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.entities.GuildImpl;
import de.staffchat.shaded.jda.internal.requests.RestActionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import okhttp3.RequestBody;

public class StageInstanceActionImpl
extends RestActionImpl<StageInstance>
implements StageInstanceAction {
    private final StageChannel channel;
    private String topic;

    public StageInstanceActionImpl(StageChannel channel) {
        super(channel.getJDA(), Route.StageInstances.CREATE_INSTANCE.compile(new String[0]));
        this.channel = channel;
    }

    @Override
    @Nonnull
    public StageInstanceAction setCheck(BooleanSupplier checks) {
        return (StageInstanceAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public StageInstanceAction timeout(long timeout2, @Nonnull TimeUnit unit) {
        return (StageInstanceAction)super.timeout(timeout2, unit);
    }

    @Override
    @Nonnull
    public StageInstanceAction deadline(long timestamp) {
        return (StageInstanceAction)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public StageInstanceAction setTopic(@Nonnull String topic) {
        Checks.notBlank(topic, "Topic");
        Checks.notLonger(topic, 120, "Topic");
        this.topic = topic;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        body.put("channel_id", this.channel.getId());
        body.put("topic", this.topic);
        return this.getRequestBody(body);
    }

    @Override
    protected void handleSuccess(Response response, Request<StageInstance> request) {
        StageInstance instance = this.api.getEntityBuilder().createStageInstance((GuildImpl)this.channel.getGuild(), response.getObject());
        request.onSuccess(instance);
    }
}

