/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.interactions.commands.Command;
import de.staffchat.shaded.jda.api.interactions.commands.build.CommandData;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.CommandListUpdateAction;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.entities.GuildImpl;
import de.staffchat.shaded.jda.internal.interactions.command.CommandImpl;
import de.staffchat.shaded.jda.internal.requests.RestActionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import okhttp3.RequestBody;

public class CommandListUpdateActionImpl
extends RestActionImpl<List<Command>>
implements CommandListUpdateAction {
    private final List<CommandData> commands = new ArrayList<CommandData>();
    private final GuildImpl guild;
    private int slash;
    private int user;
    private int message;

    public CommandListUpdateActionImpl(JDA api, GuildImpl guild, Route.CompiledRoute route) {
        super(api, route);
        this.guild = guild;
    }

    @Override
    @Nonnull
    public CommandListUpdateAction timeout(long timeout2, @Nonnull TimeUnit unit) {
        return (CommandListUpdateAction)super.timeout(timeout2, unit);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction addCheck(@Nonnull BooleanSupplier checks) {
        return (CommandListUpdateAction)super.addCheck(checks);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction setCheck(BooleanSupplier checks) {
        return (CommandListUpdateAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction deadline(long timestamp) {
        return (CommandListUpdateAction)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction addCommands(@Nonnull Collection<? extends CommandData> commands) {
        Checks.noneNull(commands, "Command");
        int newSlash = 0;
        int newUser = 0;
        int newMessage = 0;
        for (CommandData commandData : commands) {
            switch (commandData.getType()) {
                case SLASH: {
                    ++newSlash;
                    break;
                }
                case MESSAGE: {
                    ++newMessage;
                    break;
                }
                case USER: {
                    ++newUser;
                }
            }
        }
        Checks.check(this.slash + newSlash <= 100, "Cannot have more than %d slash commands! Try using subcommands instead.", (Object)100);
        Checks.check(this.user + newUser <= 5, "Cannot have more than %d user context commands!", (Object)5);
        Checks.check(this.message + newMessage <= 5, "Cannot have more than %d message context commands!", (Object)5);
        Checks.checkUnique(Stream.concat(commands.stream(), this.commands.stream()).map((? super T c) -> (Object)((Object)c.getType()) + " " + c.getName()), "Cannot have multiple commands of the same type with identical names. Name: \"%s\" with type %s appeared %d times!", (count, value) -> {
            String[] tuple = value.split(" ", 2);
            return new Object[]{tuple[1], tuple[0], count};
        });
        this.slash += newSlash;
        this.user += newUser;
        this.message += newMessage;
        this.commands.addAll(commands);
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataArray json = DataArray.empty();
        json.addAll(this.commands);
        return this.getRequestBody(json);
    }

    @Override
    protected void handleSuccess(Response response, Request<List<Command>> request) {
        List commands = response.getArray().stream(DataArray::getObject).map((? super T obj) -> new CommandImpl(this.api, this.guild, (DataObject)obj)).collect(Collectors.toList());
        request.onSuccess(commands);
    }
}

