/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.IncomingWebhookClient;
import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.WebhookMessageDeleteAction;
import de.staffchat.shaded.jda.api.requests.restaction.WebhookMessageRetrieveAction;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.AbstractWebhookClient;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.ReceivedMessage;
import de.staffchat.shaded.jda.internal.requests.restaction.WebhookMessageCreateActionImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.WebhookMessageDeleteActionImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.WebhookMessageEditActionImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.WebhookMessageRetrieveActionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class IncomingWebhookClientImpl
extends AbstractWebhookClient<Message>
implements IncomingWebhookClient {
    public IncomingWebhookClientImpl(long webhookId, String webhookToken, JDA api) {
        super(webhookId, webhookToken, api);
    }

    @Override
    public WebhookMessageCreateActionImpl<Message> sendRequest() {
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK.compile(Long.toUnsignedString(this.id), this.token);
        route = route.withQueryParams("wait", "true");
        route = route.withQueryParams("with_components", "true");
        WebhookMessageCreateActionImpl<Message> action = new WebhookMessageCreateActionImpl<Message>(this.api, route, this.builder());
        action.run();
        action.setInteraction(false);
        return action;
    }

    @Override
    public WebhookMessageEditActionImpl<Message> editRequest(@Nonnull String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_EDIT.compile(Long.toUnsignedString(this.id), this.token, messageId);
        route = route.withQueryParams("wait", "true");
        route = route.withQueryParams("with_components", "true");
        WebhookMessageEditActionImpl<Message> action = new WebhookMessageEditActionImpl<Message>(this.api, route, this.builder());
        action.run();
        return action;
    }

    @Override
    @Nonnull
    public WebhookMessageRetrieveAction retrieveMessageById(@Nonnull String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_FETCH.compile(Long.toUnsignedString(this.id), this.token, messageId);
        WebhookMessageRetrieveActionImpl action = new WebhookMessageRetrieveActionImpl(this.api, route, (response, request) -> this.builder().apply(response.getObject()));
        action.run();
        return action;
    }

    @Override
    @Nonnull
    public WebhookMessageDeleteAction deleteMessageById(@Nonnull String messageId) {
        WebhookMessageDeleteActionImpl action = (WebhookMessageDeleteActionImpl)super.deleteMessageById(messageId);
        action.run();
        return action;
    }

    private Function<DataObject, Message> builder() {
        return data -> {
            JDAImpl jda = (JDAImpl)this.api;
            long channelId = data.getUnsignedLong("channel_id");
            MessageChannel channel = this.api.getChannelById(MessageChannel.class, channelId);
            EntityBuilder entityBuilder = jda.getEntityBuilder();
            ReceivedMessage message = entityBuilder.createMessageBestEffort((DataObject)data, channel, null);
            message.withHook(this);
            return message;
        };
    }
}

