/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.managers;

import de.staffchat.shaded.jda.api.entities.emoji.ApplicationEmoji;
import de.staffchat.shaded.jda.api.managers.ApplicationEmojiManager;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.managers.ManagerBase;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import okhttp3.RequestBody;

public class ApplicationEmojiManagerImpl
extends ManagerBase<ApplicationEmojiManager>
implements ApplicationEmojiManager {
    protected final ApplicationEmoji emoji;
    protected String name;

    public ApplicationEmojiManagerImpl(ApplicationEmoji emoji) {
        super(emoji.getJDA(), Route.Applications.MODIFY_APPLICATION_EMOJI.compile(emoji.getJDA().getSelfUser().getApplicationId(), emoji.getId()));
        this.emoji = emoji;
    }

    @Override
    @Nonnull
    public ApplicationEmoji getEmoji() {
        return this.emoji;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public ApplicationEmojiManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public ApplicationEmojiManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    public ApplicationEmojiManager setName(@Nonnull String name) {
        Checks.inRange(name, 2, 32, "Emoji name");
        Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Emoji name");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject object = DataObject.empty();
        if (this.shouldUpdate(1L)) {
            object.put("name", this.name);
        }
        this.reset();
        return this.getRequestBody(object);
    }
}

