/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.handle;

import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.channel.concrete.PrivateChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.events.user.UserTypingEvent;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.GuildImpl;
import de.staffchat.shaded.jda.internal.entities.MemberImpl;
import de.staffchat.shaded.jda.internal.handle.SocketHandler;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class TypingStartHandler
extends SocketHandler {
    public TypingStartHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        GuildImpl guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getUnsignedLong("guild_id");
            guild = (GuildImpl)this.getJDA().getGuildById(guildId);
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
            if (guild == null) {
                return null;
            }
        }
        long channelId = content.getLong("channel_id");
        MessageChannel channel = this.getJDA().getChannelById(MessageChannel.class, channelId);
        if (channel == null) {
            return null;
        }
        long userId = content.getLong("user_id");
        MemberImpl member = null;
        User user = channel instanceof PrivateChannel ? ((PrivateChannel)channel).getUser() : (User)this.getJDA().getUsersView().get(userId);
        if (!content.isNull("member")) {
            EntityBuilder entityBuilder = this.getJDA().getEntityBuilder();
            member = entityBuilder.createMember(guild, content.getObject("member"));
            entityBuilder.updateMemberCache(member);
            user = member.getUser();
        }
        if (user == null) {
            return null;
        }
        OffsetDateTime timestamp = Instant.ofEpochSecond(content.getInt("timestamp")).atOffset(ZoneOffset.UTC);
        this.getJDA().handleEvent(new UserTypingEvent(this.getJDA(), this.responseNumber, user, channel, timestamp, member));
        return null;
    }
}

