/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.handle;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.entities.channel.ChannelType;
import de.staffchat.shaded.jda.api.events.interaction.GenericInteractionCreateEvent;
import de.staffchat.shaded.jda.api.events.interaction.ModalInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.command.MessageContextInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.command.UserContextInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.component.ButtonInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.component.EntitySelectInteractionEvent;
import de.staffchat.shaded.jda.api.events.interaction.component.StringSelectInteractionEvent;
import de.staffchat.shaded.jda.api.interactions.InteractionType;
import de.staffchat.shaded.jda.api.interactions.commands.Command;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.handle.SocketHandler;
import de.staffchat.shaded.jda.internal.interactions.InteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.command.CommandAutoCompleteInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.command.MessageContextInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.command.SlashCommandInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.command.UserContextInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.components.buttons.ButtonInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.components.selections.EntitySelectInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.components.selections.StringSelectInteractionImpl;
import de.staffchat.shaded.jda.internal.interactions.modal.ModalInteractionImpl;
import de.staffchat.shaded.jda.internal.requests.WebSocketClient;

public class InteractionCreateHandler
extends SocketHandler {
    public InteractionCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        int type = content.getInt("type");
        int version = content.getInt("version", 1);
        if (version != 1) {
            WebSocketClient.LOG.debug("Received interaction with version {}. This version is currently unsupported by this version of JDA. Consider updating!", (Object)version);
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id", 0L);
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        DataObject channelJson = content.getObject("channel");
        ChannelType channelType = ChannelType.fromId(channelJson.getInt("type"));
        if (!channelType.isMessage()) {
            WebSocketClient.LOG.debug("Discarding INTERACTION_CREATE event from unexpected channel type. Channel: {}", (Object)channelJson);
            return null;
        }
        switch (InteractionType.fromKey(type)) {
            case COMMAND: {
                this.handleCommand(content);
                break;
            }
            case COMPONENT: {
                this.handleAction(content);
                break;
            }
            case COMMAND_AUTOCOMPLETE: {
                this.api.handleEvent(new CommandAutoCompleteInteractionEvent((JDA)this.api, this.responseNumber, new CommandAutoCompleteInteractionImpl(this.api, content)));
                break;
            }
            case MODAL_SUBMIT: {
                this.api.handleEvent(new ModalInteractionEvent((JDA)this.api, this.responseNumber, new ModalInteractionImpl(this.api, content)));
                break;
            }
            default: {
                this.api.handleEvent(new GenericInteractionCreateEvent(this.api, this.responseNumber, new InteractionImpl(this.api, content)));
            }
        }
        return null;
    }

    private void handleCommand(DataObject content) {
        switch (Command.Type.fromId(content.getObject("data").getInt("type"))) {
            case SLASH: {
                this.api.handleEvent(new SlashCommandInteractionEvent((JDA)this.api, this.responseNumber, new SlashCommandInteractionImpl(this.api, content)));
                break;
            }
            case MESSAGE: {
                this.api.handleEvent(new MessageContextInteractionEvent((JDA)this.api, this.responseNumber, new MessageContextInteractionImpl(this.api, content)));
                break;
            }
            case USER: {
                this.api.handleEvent(new UserContextInteractionEvent((JDA)this.api, this.responseNumber, new UserContextInteractionImpl(this.api, content)));
            }
        }
    }

    private void handleAction(DataObject content) {
        switch (Component.Type.fromKey(content.getObject("data").getInt("component_type"))) {
            case BUTTON: {
                this.api.handleEvent(new ButtonInteractionEvent((JDA)this.api, this.responseNumber, new ButtonInteractionImpl(this.api, content)));
                break;
            }
            case STRING_SELECT: {
                this.api.handleEvent(new StringSelectInteractionEvent((JDA)this.api, this.responseNumber, new StringSelectInteractionImpl(this.api, content)));
                break;
            }
            case USER_SELECT: 
            case ROLE_SELECT: 
            case MENTIONABLE_SELECT: 
            case CHANNEL_SELECT: {
                this.api.handleEvent(new EntitySelectInteractionEvent((JDA)this.api, this.responseNumber, new EntitySelectInteractionImpl(this.api, content)));
            }
        }
    }
}

