/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.handle;

import de.staffchat.shaded.jda.api.events.guild.GuildLeaveEvent;
import de.staffchat.shaded.jda.api.events.guild.GuildUnavailableEvent;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.GuildImpl;
import de.staffchat.shaded.jda.internal.handle.EventCache;
import de.staffchat.shaded.jda.internal.handle.GuildSetupController;
import de.staffchat.shaded.jda.internal.handle.SocketHandler;
import de.staffchat.shaded.jda.internal.requests.WebSocketClient;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long id = content.getLong("id");
        GuildSetupController setupController = this.getJDA().getGuildSetupController();
        boolean wasInit = setupController.onDelete(id, content);
        if (wasInit || setupController.isUnavailable(id)) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        boolean unavailable = content.getBoolean("unavailable");
        if (guild == null) {
            WebSocketClient.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: {} unavailable: {}", (Object)id, (Object)unavailable);
            return null;
        }
        if (setupController.isUnavailable(id) && unavailable) {
            return null;
        }
        guild.invalidate();
        if (unavailable) {
            setupController.onUnavailable(id);
            this.getJDA().handleEvent(new GuildUnavailableEvent(this.getJDA(), this.responseNumber, guild));
        } else {
            this.getJDA().handleEvent(new GuildLeaveEvent(this.getJDA(), this.responseNumber, guild));
        }
        this.getJDA().getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

