/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.handle;

import de.staffchat.shaded.jda.api.entities.channel.Channel;
import de.staffchat.shaded.jda.api.entities.channel.ChannelType;
import de.staffchat.shaded.jda.api.events.channel.ChannelCreateEvent;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.handle.SocketHandler;
import de.staffchat.shaded.jda.internal.requests.WebSocketClient;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        Channel channel;
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        JDAImpl jda = this.getJDA();
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (jda.getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        if ((channel = this.buildChannel(type, content, guildId)) == null) {
            WebSocketClient.LOG.debug("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: {}", (Object)content);
            return null;
        }
        jda.handleEvent(new ChannelCreateEvent(jda, this.responseNumber, channel));
        return null;
    }

    private Channel buildChannel(ChannelType type, DataObject content, long guildId) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        switch (type) {
            case TEXT: {
                return builder.createTextChannel(content, guildId);
            }
            case NEWS: {
                return builder.createNewsChannel(content, guildId);
            }
            case VOICE: {
                return builder.createVoiceChannel(content, guildId);
            }
            case STAGE: {
                return builder.createStageChannel(content, guildId);
            }
            case CATEGORY: {
                return builder.createCategory(content, guildId);
            }
            case FORUM: {
                return builder.createForumChannel(content, guildId);
            }
            case MEDIA: {
                return builder.createMediaChannel(content, guildId);
            }
        }
        return null;
    }
}

