/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.emoji;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.emoji.ApplicationEmoji;
import de.staffchat.shaded.jda.api.entities.emoji.CustomEmoji;
import de.staffchat.shaded.jda.api.entities.emoji.Emoji;
import de.staffchat.shaded.jda.api.entities.emoji.EmojiUnion;
import de.staffchat.shaded.jda.api.entities.emoji.RichCustomEmoji;
import de.staffchat.shaded.jda.api.entities.emoji.UnicodeEmoji;
import de.staffchat.shaded.jda.api.managers.ApplicationEmojiManager;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.managers.ApplicationEmojiManagerImpl;
import de.staffchat.shaded.jda.internal.requests.RestActionImpl;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationEmojiImpl
implements ApplicationEmoji,
EmojiUnion {
    private final long id;
    private final JDAImpl api;
    private final User owner;
    boolean animated = false;
    private String name;

    public ApplicationEmojiImpl(long id, JDAImpl api, User owner) {
        this.id = id;
        this.api = api;
        this.owner = owner;
    }

    @Override
    @Nonnull
    public Emoji.Type getType() {
        return Emoji.Type.CUSTOM;
    }

    @Override
    @Nonnull
    public String getAsReactionCode() {
        return this.name + ":" + this.id;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name).put("animated", this.animated).put("id", this.id);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nullable
    public User getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ApplicationEmojiManager getManager() {
        return new ApplicationEmojiManagerImpl(this);
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    @Nonnull
    public RestAction<Void> delete() {
        Route.CompiledRoute route = Route.Applications.DELETE_APPLICATION_EMOJI.compile(this.getJDA().getSelfUser().getApplicationId(), this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    public ApplicationEmojiImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ApplicationEmojiImpl setAnimated(boolean animated) {
        this.animated = animated;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationEmojiImpl)) {
            return false;
        }
        ApplicationEmojiImpl other = (ApplicationEmojiImpl)obj;
        return this.id == other.getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return new EntityString(this).setName(this.name).toString();
    }

    @Override
    @Nonnull
    public UnicodeEmoji asUnicode() {
        throw new IllegalStateException("Cannot convert ApplicationEmoji to UnicodeEmoji!");
    }

    @Override
    @Nonnull
    public CustomEmoji asCustom() {
        return this;
    }

    @Override
    @Nonnull
    public RichCustomEmoji asRich() {
        throw new IllegalStateException("Cannot convert ApplicationEmoji to RichCustomEmoji!");
    }

    @Override
    @Nonnull
    public ApplicationEmoji asApplication() {
        return this;
    }
}

