/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.detached;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Role;
import de.staffchat.shaded.jda.api.entities.RoleColors;
import de.staffchat.shaded.jda.api.entities.RoleIcon;
import de.staffchat.shaded.jda.api.entities.channel.attribute.IPermissionContainer;
import de.staffchat.shaded.jda.api.entities.channel.middleman.GuildChannel;
import de.staffchat.shaded.jda.api.exceptions.DetachedEntityException;
import de.staffchat.shaded.jda.api.managers.RoleManager;
import de.staffchat.shaded.jda.api.requests.restaction.AuditableRestAction;
import de.staffchat.shaded.jda.api.utils.cache.CacheFlag;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.RoleImpl;
import de.staffchat.shaded.jda.internal.entities.detached.DetachedGuildImpl;
import de.staffchat.shaded.jda.internal.entities.mixin.RoleMixin;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import de.staffchat.shaded.jda.internal.utils.PermissionUtil;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DetachedRoleImpl
implements Role,
RoleMixin<DetachedRoleImpl> {
    private final long id;
    private final JDAImpl api;
    private final DetachedGuildImpl guild;
    private RoleImpl.RoleTagsImpl tags;
    private String name;
    private boolean managed;
    private boolean hoisted;
    private boolean mentionable;
    private long rawPermissions;
    private int primaryColor;
    private int secondaryColor = 0x1FFFFFFF;
    private int tertiaryColor = 0x1FFFFFFF;
    private int rawPosition;
    private RoleIcon icon;

    public DetachedRoleImpl(long id, DetachedGuildImpl guild) {
        this.id = id;
        this.api = guild.getJDA();
        this.guild = guild;
        this.tags = this.api.isCacheFlagSet(CacheFlag.ROLE_TAGS) ? new RoleImpl.RoleTagsImpl() : null;
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public int getPosition() {
        throw new DetachedEntityException("Cannot get the position of a detached role, only the raw position is available");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isHoisted() {
        return this.hoisted;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public long getPermissionsRaw() {
        return this.rawPermissions;
    }

    @Override
    @Nonnull
    public RoleColors getColors() {
        return new RoleColors(this.primaryColor, this.secondaryColor, this.tertiaryColor);
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions(this.rawPermissions);
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions(@Nonnull GuildChannel channel) {
        throw this.detachedException();
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit() {
        return this.getPermissions();
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit(@Nonnull GuildChannel channel) {
        throw this.detachedException();
    }

    @Override
    public boolean isPublicRole() {
        return this.getIdLong() == this.getGuild().getIdLong();
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        long effectivePerms = this.rawPermissions;
        for (Permission perm : permissions) {
            long rawValue = perm.getRawValue();
            if ((effectivePerms & rawValue) == rawValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(@Nonnull GuildChannel channel, Permission ... permissions) {
        throw this.detachedException();
    }

    @Override
    public boolean canSync(@Nonnull IPermissionContainer targetChannel, @Nonnull IPermissionContainer syncSource) {
        throw this.detachedException();
    }

    @Override
    public boolean canSync(@Nonnull IPermissionContainer channel) {
        throw this.detachedException();
    }

    @Override
    public boolean canInteract(@Nonnull Role role) {
        return PermissionUtil.canInteract(this, role);
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    @Nonnull
    public RoleManager getManager() {
        throw this.detachedException();
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        throw this.detachedException();
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public Role.RoleTags getTags() {
        return this.tags == null ? RoleImpl.RoleTagsImpl.EMPTY : this.tags;
    }

    @Override
    @Nullable
    public RoleIcon getIcon() {
        return this.icon;
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return this.isPublicRole() ? "@everyone" : "<@&" + this.getId() + '>';
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetachedRoleImpl)) {
            return false;
        }
        DetachedRoleImpl oRole = (DetachedRoleImpl)o;
        return this.getIdLong() == oRole.getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return new EntityString(this).setName(this.getName()).toString();
    }

    @Override
    public DetachedRoleImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DetachedRoleImpl setPrimaryColor(int color) {
        this.primaryColor = color;
        return this;
    }

    @Override
    public DetachedRoleImpl setSecondaryColor(int color) {
        this.secondaryColor = color;
        return this;
    }

    @Override
    public DetachedRoleImpl setTertiaryColor(int color) {
        this.tertiaryColor = color;
        return this;
    }

    @Override
    public DetachedRoleImpl setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    @Override
    public DetachedRoleImpl setHoisted(boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    @Override
    public DetachedRoleImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    @Override
    public DetachedRoleImpl setRawPermissions(long rawPermissions) {
        this.rawPermissions = rawPermissions;
        return this;
    }

    @Override
    public DetachedRoleImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }

    @Override
    public DetachedRoleImpl setTags(DataObject tags) {
        if (this.tags == null) {
            return this;
        }
        this.tags = new RoleImpl.RoleTagsImpl(tags);
        return this;
    }

    @Override
    public DetachedRoleImpl setIcon(RoleIcon icon) {
        this.icon = icon;
        return this;
    }
}

