/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.channel.mixin.concrete;

import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.Region;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.PermissionOverride;
import de.staffchat.shaded.jda.api.entities.channel.concrete.Category;
import de.staffchat.shaded.jda.api.entities.channel.concrete.VoiceChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.GuildChannel;
import de.staffchat.shaded.jda.api.requests.restaction.ChannelAction;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.middleman.AudioChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.middleman.GuildMessageChannelMixin;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public interface VoiceChannelMixin<T extends VoiceChannelMixin<T>>
extends VoiceChannel,
GuildMessageChannelMixin<T>,
AudioChannelMixin<T>,
IWebhookContainerMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T> {
    @Override
    default public boolean canTalk(@Nonnull Member member) {
        Checks.notNull(member, "Member");
        return member.hasPermission((GuildChannel)this, Permission.MESSAGE_SEND);
    }

    @Override
    @Nonnull
    default public ChannelAction<VoiceChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<VoiceChannel> action = guild.createVoiceChannel(this.getName()).setBitrate(this.getBitrate()).setUserlimit(this.getUserLimit());
        if (this.getRegionRaw() != null) {
            action.setRegion(Region.fromKey(this.getRegionRaw()));
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    public T setStatus(String var1);
}

