/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.channel.mixin.concrete;

import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.PermissionOverride;
import de.staffchat.shaded.jda.api.entities.channel.attribute.IPostContainer;
import de.staffchat.shaded.jda.api.entities.channel.concrete.Category;
import de.staffchat.shaded.jda.api.entities.channel.concrete.MediaChannel;
import de.staffchat.shaded.jda.api.entities.emoji.UnicodeEmoji;
import de.staffchat.shaded.jda.api.requests.restaction.ChannelAction;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IPostContainerMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.ITopicChannelMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.middleman.StandardGuildChannelMixin;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public interface MediaChannelMixin<T extends MediaChannelMixin<T>>
extends MediaChannel,
StandardGuildChannelMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T>,
IWebhookContainerMixin<T>,
IPostContainerMixin<T>,
ITopicChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<MediaChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<MediaChannel> action = guild.createMediaChannel(this.getName()).setNSFW(this.isNSFW()).setTopic(this.getTopic()).setSlowmode(this.getSlowmode()).setAvailableTags(this.getAvailableTags());
        if (this.getRawSortOrder() != -1) {
            action.setDefaultSortOrder(IPostContainer.SortOrder.fromKey(this.getRawSortOrder()));
        }
        if (this.getDefaultReaction() instanceof UnicodeEmoji) {
            action.setDefaultReaction(this.getDefaultReaction());
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            action.setDefaultReaction(this.getDefaultReaction());
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

