/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute;

import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.entities.channel.attribute.IPostContainer;
import de.staffchat.shaded.jda.api.entities.channel.forums.ForumTag;
import de.staffchat.shaded.jda.api.requests.restaction.ForumPostAction;
import de.staffchat.shaded.jda.api.requests.restaction.ThreadChannelAction;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.api.utils.messages.MessageCreateBuilder;
import de.staffchat.shaded.jda.api.utils.messages.MessageCreateData;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute.IThreadContainerMixin;
import de.staffchat.shaded.jda.internal.requests.restaction.ForumPostActionImpl;
import de.staffchat.shaded.jda.internal.utils.cache.SortedSnowflakeCacheViewImpl;
import javax.annotation.Nonnull;

public interface IPostContainerMixin<T extends IPostContainerMixin<T>>
extends IPostContainer,
IThreadContainerMixin<T> {
    @Nonnull
    public SortedSnowflakeCacheViewImpl<ForumTag> getAvailableTagCache();

    @Override
    @Nonnull
    default public ForumPostAction createForumPost(@Nonnull String name, @Nonnull MessageCreateData message) {
        this.checkAttached();
        this.checkPermission(Permission.MESSAGE_SEND);
        return new ForumPostActionImpl(this, name, (MessageCreateBuilder)new MessageCreateBuilder().applyData(message));
    }

    @Override
    @Nonnull
    default public ThreadChannelAction createThreadChannel(@Nonnull String name) {
        throw new UnsupportedOperationException("You cannot create threads without a message payload in forum/media channels! Use createForumPost(...) instead.");
    }

    @Override
    @Nonnull
    default public ThreadChannelAction createThreadChannel(@Nonnull String name, @Nonnull String messageId) {
        throw new UnsupportedOperationException("You cannot create threads without a message payload in forum/media channels! Use createForumPost(...) instead.");
    }

    public T setDefaultReaction(DataObject var1);

    public T setDefaultSortOrder(int var1);

    public T setFlags(int var1);

    public int getRawSortOrder();

    public int getRawFlags();
}

