/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities.channel.mixin.attribute;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.entities.Invite;
import de.staffchat.shaded.jda.api.entities.channel.attribute.IInviteContainer;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.InviteAction;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.internal.JDAImpl;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.channel.mixin.middleman.GuildChannelMixin;
import de.staffchat.shaded.jda.internal.requests.RestActionImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.InviteActionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public interface IInviteContainerMixin<T extends IInviteContainerMixin<T>>
extends IInviteContainer,
GuildChannelMixin<T> {
    @Override
    @Nonnull
    default public InviteAction createInvite() {
        this.checkAttached();
        this.checkPermission(Permission.CREATE_INSTANT_INVITE);
        return new InviteActionImpl(this.getJDA(), this.getId());
    }

    @Override
    @Nonnull
    default public RestAction<List<Invite>> retrieveInvites() {
        this.checkAttached();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Invites.GET_CHANNEL_INVITES.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Invite>>((JDA)jda, route, (response, request) -> {
            EntityBuilder entityBuilder = jda.getEntityBuilder();
            DataArray array = response.getArray();
            ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                invites.add(entityBuilder.createInvite(array.getObject(i)));
            }
            return Collections.unmodifiableList(invites);
        });
    }
}

