/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.entities;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.ThreadMember;
import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.channel.concrete.ThreadChannel;
import de.staffchat.shaded.jda.internal.entities.channel.concrete.ThreadChannelImpl;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;

public class ThreadMemberImpl
implements ThreadMember {
    private final JDA api;
    private final ThreadChannelImpl thread;
    private Member member;
    private long joinedTimestamp;

    public ThreadMemberImpl(Member member, ThreadChannelImpl thread) {
        this.api = member.getJDA();
        this.member = member;
        this.thread = thread;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.thread.getGuild();
    }

    @Override
    @Nonnull
    public ThreadChannel getThread() {
        return this.thread;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.member.getUser();
    }

    @Override
    @Nonnull
    public Member getMember() {
        return this.member;
    }

    @Override
    @Nonnull
    public OffsetDateTime getTimeJoined() {
        return Helpers.toOffset(this.joinedTimestamp);
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return this.member.getAsMention();
    }

    @Override
    public long getIdLong() {
        return this.member.getIdLong();
    }

    public ThreadMemberImpl setJoinedTimestamp(long joinedTimestamp) {
        this.joinedTimestamp = joinedTimestamp;
        return this;
    }

    public String toString() {
        return new EntityString(this).addMetadata("member", this.getMember()).toString();
    }
}

