/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.components.thumbnail;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.ResolvedMedia;
import de.staffchat.shaded.jda.api.components.section.SectionAccessoryComponentUnion;
import de.staffchat.shaded.jda.api.components.thumbnail.Thumbnail;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.AbstractComponentImpl;
import de.staffchat.shaded.jda.internal.entities.FileContainerMixin;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ThumbnailFileUpload
extends AbstractComponentImpl
implements Thumbnail,
SectionAccessoryComponentUnion,
FileContainerMixin {
    private final int uniqueId;
    private final FileUpload file;
    private final String description;
    private final boolean spoiler;

    public ThumbnailFileUpload(FileUpload file) {
        this(-1, file, null, false);
    }

    public ThumbnailFileUpload(int uniqueId, FileUpload file, String description, boolean spoiler) {
        this.uniqueId = uniqueId;
        this.file = file;
        this.description = description;
        this.spoiler = spoiler;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.THUMBNAIL;
    }

    @Override
    @Nonnull
    public ThumbnailFileUpload withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new ThumbnailFileUpload(uniqueId, this.file, this.description, this.spoiler);
    }

    @Override
    @Nonnull
    public Thumbnail withDescription(@Nullable String description) {
        if (description != null) {
            Checks.notBlank(description, "Description");
            Checks.notLonger(description, 1024, "Description");
        }
        return new ThumbnailFileUpload(this.uniqueId, this.file, description, this.spoiler);
    }

    @Override
    @Nonnull
    public Thumbnail withSpoiler(boolean spoiler) {
        return new ThumbnailFileUpload(this.uniqueId, this.file, this.description, spoiler);
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return "attachment://" + this.file.getName();
    }

    @Override
    public Stream<FileUpload> getFiles() {
        return Stream.of(this.file);
    }

    @Override
    @Nullable
    public ResolvedMedia getResolvedMedia() {
        return null;
    }

    @Override
    @Nullable
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.file.getDescription();
    }

    @Override
    public boolean isSpoiler() {
        return this.spoiler;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", this.getType().getKey()).put("media", DataObject.empty().put("url", this.getUrl())).put("spoiler", this.spoiler);
        if (this.uniqueId >= 0) {
            json.put("id", this.uniqueId);
        }
        if (this.getDescription() != null) {
            json.put("description", this.getDescription());
        }
        return json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThumbnailFileUpload)) {
            return false;
        }
        ThumbnailFileUpload thumbnail = (ThumbnailFileUpload)o;
        return this.uniqueId == thumbnail.uniqueId && this.spoiler == thumbnail.spoiler && Objects.equals(this.file, thumbnail.file) && Objects.equals(this.description, thumbnail.description);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.file, this.description, this.spoiler);
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("file", this.file).addMetadata("spoiler", this.spoiler).addMetadata("description", this.description).toString();
    }
}

