/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.components.textdisplay;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.components.ModalTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponentUnion;
import de.staffchat.shaded.jda.api.components.section.SectionContentComponentUnion;
import de.staffchat.shaded.jda.api.components.textdisplay.TextDisplay;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.AbstractComponentImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TextDisplayImpl
extends AbstractComponentImpl
implements TextDisplay,
MessageTopLevelComponentUnion,
ModalTopLevelComponentUnion,
ContainerChildComponentUnion,
SectionContentComponentUnion {
    private final int uniqueId;
    private final String content;

    public TextDisplayImpl(DataObject data) {
        this(data.getInt("id", -1), data.getString("content"));
    }

    public TextDisplayImpl(String content) {
        this(-1, content);
    }

    private TextDisplayImpl(int uniqueId, String content) {
        this.content = content;
        this.uniqueId = uniqueId;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.TEXT_DISPLAY;
    }

    @Override
    @Nonnull
    public TextDisplayImpl withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new TextDisplayImpl(uniqueId, this.content);
    }

    @Override
    @Nonnull
    public TextDisplay withContent(@Nonnull String content) {
        Checks.notBlank(content, "Content");
        return new TextDisplayImpl(this.uniqueId, content);
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getContent() {
        return this.content;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", this.getType().getKey()).put("content", this.content);
        if (this.uniqueId >= 0) {
            json.put("id", this.uniqueId);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextDisplayImpl)) {
            return false;
        }
        TextDisplayImpl that = (TextDisplayImpl)o;
        return this.uniqueId == that.uniqueId && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.content);
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("content", this.content).toString();
    }
}

