/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.components.label;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.ModalTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.components.label.Label;
import de.staffchat.shaded.jda.api.components.label.LabelChildComponent;
import de.staffchat.shaded.jda.api.components.label.LabelChildComponentUnion;
import de.staffchat.shaded.jda.api.components.utils.ComponentDeserializer;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.AbstractComponentImpl;
import de.staffchat.shaded.jda.internal.components.utils.ComponentsUtil;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LabelImpl
extends AbstractComponentImpl
implements Label,
ModalTopLevelComponentUnion {
    private final int uniqueId;
    private final String label;
    private final String description;
    private final LabelChildComponentUnion child;

    public LabelImpl(@Nonnull ComponentDeserializer deserializer, @Nonnull DataObject object) {
        this(object.getInt("id", -1), object.getString("label"), object.getString("description", null), deserializer.deserializeAs(LabelChildComponentUnion.class, object.getObject("component")));
    }

    public LabelImpl(@Nonnull String label, @Nullable String description, @Nonnull LabelChildComponentUnion child) {
        this(-1, label, description, child);
    }

    private LabelImpl(int uniqueId, @Nonnull String label, @Nullable String description, @Nonnull LabelChildComponentUnion child) {
        this.uniqueId = uniqueId;
        this.label = label;
        this.description = description;
        this.child = child;
    }

    public static Label validated(@Nonnull String label, @Nullable String description, @Nonnull LabelChildComponent child) {
        Checks.notBlank(label, "Label");
        Checks.notLonger(label, 45, "Label");
        Checks.notNull(child, "Child");
        if (description != null) {
            Checks.notBlank(description, "Description");
            Checks.notLonger(description, 100, "Description");
        }
        LabelChildComponentUnion childUnion = ComponentsUtil.safeUnionCast("child", child, LabelChildComponentUnion.class);
        return new LabelImpl(label, description, childUnion);
    }

    @Override
    @Nonnull
    public Label withLabel(@Nonnull String label) {
        return LabelImpl.validated(label, this.description, this.child);
    }

    @Override
    @Nonnull
    public Label withDescription(@Nullable String description) {
        return LabelImpl.validated(this.label, description, this.child);
    }

    @Override
    @Nonnull
    public Label withChild(@Nonnull LabelChildComponent child) {
        return LabelImpl.validated(this.label, this.description, child);
    }

    @Override
    @Nonnull
    public LabelImpl withUniqueId(int uniqueId) {
        return new LabelImpl(uniqueId, this.label, this.description, this.child);
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.LABEL;
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public LabelChildComponentUnion getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject obj = DataObject.empty().put("type", this.getType().getKey()).put("label", this.label).put("description", this.description).put("component", this.child);
        if (this.uniqueId >= 0) {
            obj.put("id", this.uniqueId);
        }
        return obj;
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("label", this.label).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelImpl)) {
            return false;
        }
        LabelImpl that = (LabelImpl)o;
        return this.uniqueId == that.uniqueId && Objects.equals(this.label, that.label) && Objects.equals(this.description, that.description) && Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.label, this.description, this.child);
    }
}

