/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.components.container;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.components.container.Container;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponentUnion;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.utils.ComponentDeserializer;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.AbstractComponentImpl;
import de.staffchat.shaded.jda.internal.components.utils.ComponentsUtil;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContainerImpl
extends AbstractComponentImpl
implements Container,
MessageTopLevelComponentUnion {
    private final int uniqueId;
    private final List<ContainerChildComponentUnion> components;
    private final boolean spoiler;
    private final Integer accentColor;

    public ContainerImpl(ComponentDeserializer deserializer, DataObject data) {
        this(data.getInt("id", -1), deserializer.deserializeAs(ContainerChildComponentUnion.class, data.getArray("components")).collect(Collectors.toList()), data.getBoolean("spoiler", false), data.isNull("accent_color") ? null : Integer.valueOf(data.getInt("accent_color")));
    }

    private ContainerImpl(Collection<ContainerChildComponentUnion> components) {
        this(-1, components, false, null);
    }

    public ContainerImpl(int uniqueId, Collection<ContainerChildComponentUnion> components, boolean spoiler, Integer accentColor) {
        this.uniqueId = uniqueId;
        this.components = Helpers.copyAsUnmodifiableList(components);
        this.spoiler = spoiler;
        this.accentColor = accentColor;
    }

    public static Container validated(Collection<? extends ContainerChildComponent> components) {
        return ContainerImpl.validated(-1, components, false, null);
    }

    public static Container validated(int uniqueId, Collection<? extends ContainerChildComponent> components, boolean spoiler, Integer accentColor) {
        Checks.noneNull(components, "Components");
        Checks.notEmpty(components, "Components");
        List<ContainerChildComponentUnion> componentUnions = ComponentsUtil.membersToUnion(components, ContainerChildComponentUnion.class);
        return new ContainerImpl(uniqueId, componentUnions, spoiler, accentColor);
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.CONTAINER;
    }

    @Override
    @Nonnull
    public ContainerImpl withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new ContainerImpl(uniqueId, this.components, this.spoiler, this.accentColor);
    }

    @Override
    @Nonnull
    public Container withSpoiler(boolean spoiler) {
        return new ContainerImpl(this.uniqueId, this.components, spoiler, this.accentColor);
    }

    @Override
    @Nonnull
    public Container withAccentColor(@Nullable Integer accentColor) {
        return new ContainerImpl(this.uniqueId, this.components, this.spoiler, accentColor);
    }

    @Override
    @Nonnull
    public Container withComponents(@Nonnull Collection<? extends ContainerChildComponent> components) {
        Checks.noneNull(components, "Components");
        return new ContainerImpl(this.uniqueId, ComponentsUtil.membersToUnion(components, ContainerChildComponentUnion.class), this.spoiler, this.accentColor);
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public Container replace(@Nonnull ComponentReplacer replacer) {
        Checks.notNull(replacer, "ComponentReplacer");
        return ComponentsUtil.doReplace(ContainerChildComponent.class, this.getComponents(), replacer, components -> ContainerImpl.validated(this.uniqueId, components, this.spoiler, this.accentColor));
    }

    @Override
    @Nonnull
    public List<ContainerChildComponentUnion> getComponents() {
        return this.components;
    }

    @Override
    @Nullable
    public Integer getAccentColorRaw() {
        return this.accentColor;
    }

    @Override
    public boolean isSpoiler() {
        return this.spoiler;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", this.getType().getKey()).put("components", DataArray.fromCollection(this.getComponents())).put("spoiler", this.spoiler);
        if (this.uniqueId >= 0) {
            json.put("id", this.uniqueId);
        }
        if (this.accentColor != null) {
            json.put("accent_color", this.accentColor & 0xFFFFFF);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerImpl)) {
            return false;
        }
        ContainerImpl that = (ContainerImpl)o;
        return this.uniqueId == that.uniqueId && this.spoiler == that.spoiler && Objects.equals(this.components, that.components) && Objects.equals(this.accentColor, that.accentColor);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.components, this.spoiler, this.accentColor);
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("accentColor", this.accentColor).addMetadata("spoiler", this.spoiler).addMetadata("components", this.components).toString();
    }
}

