/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.components.actionrow;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.components.actionrow.ActionRow;
import de.staffchat.shaded.jda.api.components.actionrow.ActionRowChildComponent;
import de.staffchat.shaded.jda.api.components.actionrow.ActionRowChildComponentUnion;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponentUnion;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.utils.ComponentDeserializer;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.AbstractComponentImpl;
import de.staffchat.shaded.jda.internal.components.utils.ComponentsUtil;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ActionRowImpl
extends AbstractComponentImpl
implements ActionRow,
MessageTopLevelComponentUnion,
ContainerChildComponentUnion {
    private final int uniqueId;
    private final List<ActionRowChildComponentUnion> components;

    public ActionRowImpl(ComponentDeserializer deserializer, DataObject data) {
        this(deserializer.deserializeAs(ActionRowChildComponentUnion.class, data.getArray("components")).collect(Collectors.toList()), data.getInt("id", -1));
    }

    public ActionRowImpl(Collection<ActionRowChildComponentUnion> components, int uniqueId) {
        this.uniqueId = uniqueId;
        this.components = Helpers.copyAsUnmodifiableList(components);
    }

    @Nonnull
    public static ActionRow validated(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        return ActionRowImpl.validated(components, -1);
    }

    @Nonnull
    public static ActionRow validated(@Nonnull Collection<? extends ActionRowChildComponent> components, int uniqueId) {
        Checks.notEmpty(components, "Row");
        Checks.noneNull(components, "Components");
        ActionRowImpl.checkIsValid(components);
        List<ActionRowChildComponentUnion> componentUnions = ComponentsUtil.membersToUnion(components, ActionRowChildComponentUnion.class);
        return new ActionRowImpl(componentUnions, uniqueId);
    }

    @Nonnull
    public static List<ActionRow> partitionOf(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        Checks.noneNull(components, "Components");
        Checks.notEmpty(components, "Components");
        List<ActionRowChildComponentUnion> componentUnions = ComponentsUtil.membersToUnion(components, ActionRowChildComponentUnion.class);
        ArrayList<ActionRow> rows = new ArrayList<ActionRow>();
        ArrayList<ActionRowChildComponentUnion> currentRow = new ArrayList<ActionRowChildComponentUnion>();
        Component.Type type = null;
        for (ActionRowChildComponentUnion current : componentUnions) {
            if (type != null && type != current.getType() || currentRow.size() == ActionRow.getMaxAllowed(current.getType())) {
                rows.add(ActionRow.of(currentRow));
                currentRow.clear();
            }
            type = current.getType();
            currentRow.add(current);
        }
        rows.add(ActionRow.of(currentRow));
        return rows;
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public List<ActionRowChildComponentUnion> getComponents() {
        return this.components;
    }

    @Override
    @Nonnull
    public ActionRow replace(@Nonnull ComponentReplacer replacer) {
        Checks.notNull(replacer, "ComponentReplacer");
        return ComponentsUtil.doReplace(ActionRowChildComponent.class, this.components, replacer, newComponents -> ActionRowImpl.validated(newComponents, this.uniqueId));
    }

    @Override
    @Nonnull
    public ActionRowImpl withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new ActionRowImpl(this.components, uniqueId);
    }

    @Override
    @Nonnull
    public ActionRow withComponents(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        Checks.noneNull(components, "Components");
        return new ActionRowImpl(ComponentsUtil.membersToUnion(components, ActionRowChildComponentUnion.class), this.uniqueId);
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.ACTION_ROW;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", 1).put("components", DataArray.fromCollection(this.components));
        if (this.uniqueId >= 0) {
            json.put("id", this.uniqueId);
        }
        return json;
    }

    private static void checkIsValid(Collection<? extends ActionRowChildComponent> components) {
        Map<Component.Type, List<ActionRowChildComponent>> groups2 = components.stream().collect(Collectors.groupingBy(Component::getType));
        if (groups2.size() > 1) {
            throw new IllegalArgumentException("Cannot create action row containing different component types! Provided: " + groups2.keySet());
        }
        for (Map.Entry<Component.Type, List<ActionRowChildComponent>> entry : groups2.entrySet()) {
            Component.Type type = entry.getKey();
            List<ActionRowChildComponent> list = entry.getValue();
            int maxAllowed = ActionRow.getMaxAllowed(type);
            Checks.check(list.size() <= maxAllowed, "Cannot create an action row with more than %d %s! Provided: %d", maxAllowed, type.name(), list.size());
        }
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("components", this.components).toString();
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ActionRowImpl)) {
            return false;
        }
        return this.components.equals(((ActionRowImpl)obj).components);
    }
}

