/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.utils.messages;

import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.tree.ComponentTree;
import de.staffchat.shaded.jda.api.entities.EmbedType;
import de.staffchat.shaded.jda.api.entities.IMentionable;
import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.entities.MessageEmbed;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.api.utils.messages.AbstractMessageBuilder;
import de.staffchat.shaded.jda.api.utils.messages.AllowedMentionsData;
import de.staffchat.shaded.jda.api.utils.messages.MessageData;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MessageRequest<R extends MessageRequest<R>>
extends MessageData {
    public static void setDefaultMentions(@Nullable Collection<Message.MentionType> allowedMentions) {
        AllowedMentionsData.setDefaultMentions(allowedMentions);
    }

    @Nonnull
    public static EnumSet<Message.MentionType> getDefaultMentions() {
        return AllowedMentionsData.getDefaultMentions();
    }

    public static void setDefaultMentionRepliedUser(boolean mention) {
        AllowedMentionsData.setDefaultMentionRepliedUser(mention);
    }

    public static void setDefaultUseComponentsV2(boolean use) {
        AbstractMessageBuilder.isDefaultUseComponentsV2 = use;
    }

    public static boolean isDefaultUseComponentsV2() {
        return AbstractMessageBuilder.isDefaultUseComponentsV2;
    }

    public static boolean isDefaultMentionRepliedUser() {
        return AllowedMentionsData.isDefaultMentionRepliedUser();
    }

    @Nonnull
    public R setContent(@Nullable String var1);

    @Nonnull
    public R setEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    default public R setEmbeds(MessageEmbed ... embeds) {
        return this.setEmbeds(Arrays.asList(embeds));
    }

    @Nonnull
    public R setComponents(@Nonnull Collection<? extends MessageTopLevelComponent> var1);

    @Nonnull
    default public R setComponents(MessageTopLevelComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    @Nonnull
    default public R setComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.setComponents(tree.getComponents());
    }

    @Nonnull
    public R useComponentsV2(boolean var1);

    @Nonnull
    default public R useComponentsV2() {
        return this.useComponentsV2(true);
    }

    @Nonnull
    public R setSuppressEmbeds(boolean var1);

    @Nonnull
    public R setFiles(@Nullable Collection<? extends FileUpload> var1);

    @Nonnull
    default public R setFiles(FileUpload ... files) {
        Checks.noneNull(files, "Files");
        return this.setFiles(Arrays.asList(files));
    }

    @Nonnull
    @CheckReturnValue
    public R mentionRepliedUser(boolean var1);

    @Nonnull
    @CheckReturnValue
    public R setAllowedMentions(@Nullable Collection<Message.MentionType> var1);

    @Nonnull
    @CheckReturnValue
    public R mention(@Nonnull Collection<? extends IMentionable> var1);

    @Nonnull
    @CheckReturnValue
    default public R mention(IMentionable ... mentions) {
        Checks.notNull(mentions, "Mentions");
        return this.mention(Arrays.asList(mentions));
    }

    @Nonnull
    @CheckReturnValue
    public R mentionUsers(@Nonnull Collection<String> var1);

    @Nonnull
    @CheckReturnValue
    default public R mentionUsers(String ... userIds) {
        Checks.notNull(userIds, "User IDs");
        return this.mentionUsers(Arrays.asList(userIds));
    }

    @Nonnull
    @CheckReturnValue
    default public R mentionUsers(long ... userIds) {
        Checks.notNull(userIds, "UserId array");
        String[] stringIds = new String[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            stringIds[i] = Long.toUnsignedString(userIds[i]);
        }
        return this.mentionUsers(stringIds);
    }

    @Nonnull
    @CheckReturnValue
    public R mentionRoles(@Nonnull Collection<String> var1);

    @Nonnull
    @CheckReturnValue
    default public R mentionRoles(String ... roleIds) {
        Checks.notNull(roleIds, "Role IDs");
        return this.mentionRoles(Arrays.asList(roleIds));
    }

    @Nonnull
    @CheckReturnValue
    default public R mentionRoles(long ... roleIds) {
        Checks.notNull(roleIds, "RoleId array");
        String[] stringIds = new String[roleIds.length];
        for (int i = 0; i < roleIds.length; ++i) {
            stringIds[i] = Long.toUnsignedString(roleIds[i]);
        }
        return this.mentionRoles(stringIds);
    }

    @Nonnull
    default public R applyMessage(@Nonnull Message message) {
        Checks.notNull(message, "Message");
        Checks.check(!message.getType().isSystem(), "Cannot copy a system message");
        List embeds = message.getEmbeds().stream().filter(e -> e.getType() == EmbedType.RICH).collect(Collectors.toList());
        return this.setContent(message.getContentRaw()).setEmbeds(embeds).setComponents(message.getComponents()).useComponentsV2(message.isUsingComponentsV2()).setSuppressEmbeds(message.isSuppressedEmbeds());
    }
}

