/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.utils.messages;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponentUnion;
import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.entities.MessageEmbed;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.api.utils.messages.AbstractMessageBuilder;
import de.staffchat.shaded.jda.api.utils.messages.AllowedMentionsData;
import de.staffchat.shaded.jda.api.utils.messages.MessageCreateData;
import de.staffchat.shaded.jda.api.utils.messages.MessageCreateRequest;
import de.staffchat.shaded.jda.api.utils.messages.MessageEditData;
import de.staffchat.shaded.jda.api.utils.messages.MessagePollData;
import de.staffchat.shaded.jda.internal.components.utils.ComponentsUtil;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import de.staffchat.shaded.jda.internal.utils.IOUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageCreateBuilder
extends AbstractMessageBuilder<MessageCreateData, MessageCreateBuilder>
implements MessageCreateRequest<MessageCreateBuilder> {
    private final List<FileUpload> files = new ArrayList<FileUpload>(10);
    private MessagePollData poll;
    private boolean tts;

    @Nonnull
    public static MessageCreateBuilder from(@Nonnull MessageCreateData data) {
        return (MessageCreateBuilder)new MessageCreateBuilder().applyData(data);
    }

    @Nonnull
    public static MessageCreateBuilder fromEditData(@Nonnull MessageEditData data) {
        return (MessageCreateBuilder)new MessageCreateBuilder().applyEditData(data);
    }

    @Nonnull
    public static MessageCreateBuilder fromMessage(@Nonnull Message message) {
        return (MessageCreateBuilder)new MessageCreateBuilder().applyMessage(message);
    }

    @Override
    @Nonnull
    public MessageCreateBuilder addContent(@Nonnull String content) {
        Checks.notNull(content, "Content");
        Checks.check(Helpers.codePointLength(this.content) + Helpers.codePointLength(content) <= 2000, "Cannot have content longer than %d characters", (Object)2000);
        this.content.append(content);
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder addEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        Checks.noneNull(embeds, "Embeds");
        Checks.check(this.embeds.size() + embeds.size() <= 10, "Cannot add more than %d embeds", (Object)10);
        this.embeds.addAll(embeds);
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder addComponents(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        Checks.noneNull(components, "MessageTopLevelComponents");
        Checks.checkComponents("Provided component is invalid for messages!", components, Component::isMessageCompatible);
        List<MessageTopLevelComponentUnion> componentsAsUnions = ComponentsUtil.membersToUnion(components, MessageTopLevelComponentUnion.class);
        this.components.addAll(componentsAsUnions);
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder setFiles(@Nullable Collection<? extends FileUpload> files) {
        if (files != null) {
            Checks.noneNull(files, "Files");
        }
        this.files.clear();
        if (files != null) {
            this.files.addAll(files);
            this.setVoiceMessageIfApplicable(files);
        }
        return this;
    }

    @Override
    @Nonnull
    public List<FileUpload> getAttachments() {
        return Collections.unmodifiableList(this.files);
    }

    @Override
    @Nullable
    public MessagePollData getPoll() {
        return this.poll;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder setPoll(@Nullable MessagePollData poll) {
        this.poll = poll;
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder addFiles(@Nonnull Collection<? extends FileUpload> files) {
        Checks.noneNull(files, "Files");
        this.files.addAll(files);
        this.setVoiceMessageIfApplicable(files);
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder setTTS(boolean tts) {
        this.tts = tts;
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder setSuppressedNotifications(boolean suppressed) {
        this.messageFlags = suppressed ? (this.messageFlags |= Message.MessageFlag.NOTIFICATIONS_SUPPRESSED.getValue()) : (this.messageFlags &= ~Message.MessageFlag.NOTIFICATIONS_SUPPRESSED.getValue());
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder setVoiceMessage(boolean voiceMessage) {
        this.messageFlags = voiceMessage ? (this.messageFlags |= Message.MessageFlag.IS_VOICE_MESSAGE.getValue()) : (this.messageFlags &= ~Message.MessageFlag.IS_VOICE_MESSAGE.getValue());
        return this;
    }

    @Override
    public boolean isEmpty() {
        return Helpers.isBlank(this.content) && this.embeds.isEmpty() && this.files.isEmpty() && this.components.isEmpty() && this.poll == null;
    }

    @Override
    public boolean isValid() {
        if (this.isUsingComponentsV2()) {
            return this.isV2Valid();
        }
        return this.isV1Valid();
    }

    private boolean isV1Valid() {
        return !this.isEmpty() && this.embeds.size() <= 10 && this.components.size() <= 5 && !ComponentsUtil.hasIllegalV1Components(this.components) && Helpers.codePointLength(this.content) <= 2000;
    }

    private boolean isV2Valid() {
        return this.content.length() == 0 && this.embeds.isEmpty() && this.poll == null && !this.components.isEmpty() && ComponentsUtil.getComponentTreeSize(this.components) <= 40L && ComponentsUtil.getComponentTreeTextContentLength(this.components) <= 4000L;
    }

    @Override
    @Nonnull
    public MessageCreateData build() {
        if (this.isUsingComponentsV2()) {
            return this.buildV2();
        }
        return this.buildV1();
    }

    @Nonnull
    private MessageCreateData buildV1() {
        String content = this.content.toString().trim();
        ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>(this.embeds);
        ArrayList<FileUpload> files = new ArrayList<FileUpload>(this.files);
        ArrayList<MessageTopLevelComponentUnion> components = new ArrayList<MessageTopLevelComponentUnion>(this.components);
        AllowedMentionsData mentions = this.mentions.copy();
        if (content.isEmpty() && embeds.isEmpty() && files.isEmpty() && components.isEmpty() && this.poll == null) {
            throw new IllegalStateException("Cannot build an empty message. You need at least one of content, embeds, components, poll, or files");
        }
        int length = Helpers.codePointLength(content);
        if (length > 2000) {
            throw new IllegalStateException("Message content is too long! Max length is 2000 characters, provided " + length);
        }
        if (embeds.size() > 10) {
            throw new IllegalStateException("Cannot build message with over 10 embeds, provided " + embeds.size());
        }
        if (components.size() > 5) {
            throw new IllegalStateException("Cannot build message with over 5 top-level components, provided " + components.size());
        }
        List<? extends Component> illegalV1Components = ComponentsUtil.getIllegalV1Components(components);
        if (!illegalV1Components.isEmpty()) {
            throw new IllegalStateException("Cannot build message with components other than ActionRow while using components V1, see #useComponentsV2, provided: " + illegalV1Components);
        }
        return new MessageCreateData(content, embeds, files, components, mentions, this.poll, this.tts, this.messageFlags);
    }

    @Nonnull
    private MessageCreateData buildV2() {
        ArrayList<FileUpload> files = new ArrayList<FileUpload>(this.files);
        ArrayList<MessageTopLevelComponentUnion> components = new ArrayList<MessageTopLevelComponentUnion>(this.components);
        AllowedMentionsData mentions = this.mentions.copy();
        if (this.content.length() > 0 || !this.embeds.isEmpty() || this.poll != null) {
            throw new IllegalStateException("Cannot build a message with components V2 enabled while having content, embeds, or poll");
        }
        if (components.isEmpty()) {
            throw new IllegalStateException("Cannot build message with no V2 components, or did you forget to disable them?");
        }
        long componentTreeSize = ComponentsUtil.getComponentTreeSize(components);
        if (componentTreeSize > 40L) {
            throw new IllegalStateException("Cannot build message with over 40 total components, provided " + componentTreeSize);
        }
        long componentTreeLength = ComponentsUtil.getComponentTreeTextContentLength(components);
        if (componentTreeLength > 4000L) {
            throw new IllegalStateException("Cannot build message with over 4000 total characters, provided " + componentTreeLength);
        }
        return new MessageCreateData("", Collections.emptyList(), files, components, mentions, this.poll, this.tts, this.messageFlags);
    }

    @Override
    @Nonnull
    public MessageCreateBuilder clear() {
        super.clear();
        this.files.clear();
        this.tts = false;
        return this;
    }

    @Override
    @Nonnull
    public MessageCreateBuilder closeFiles() {
        this.files.forEach(IOUtil::silentClose);
        this.files.clear();
        return this;
    }

    private void setVoiceMessageIfApplicable(@Nonnull Collection<? extends FileUpload> files) {
        if (files.stream().anyMatch(FileUpload::isVoiceMessage)) {
            this.setVoiceMessage(true);
        }
    }
}

