/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.managers;

import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Icon;
import de.staffchat.shaded.jda.api.entities.Role;
import de.staffchat.shaded.jda.api.entities.RoleColors;
import de.staffchat.shaded.jda.api.entities.emoji.UnicodeEmoji;
import de.staffchat.shaded.jda.api.managers.Manager;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RoleManager
extends Manager<RoleManager> {
    public static final long NAME = 1L;
    public static final long COLOR = 2L;
    public static final long PERMISSION = 4L;
    public static final long HOIST = 8L;
    public static final long MENTIONABLE = 16L;
    public static final long ICON = 32L;

    @Override
    @Nonnull
    @CheckReturnValue
    public RoleManager reset(long var1);

    @Override
    @Nonnull
    @CheckReturnValue
    public RoleManager reset(long ... var1);

    @Nonnull
    public Role getRole();

    @Nonnull
    default public Guild getGuild() {
        return this.getRole().getGuild();
    }

    @Nonnull
    @CheckReturnValue
    public RoleManager setName(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public RoleManager setPermissions(long var1);

    @Nonnull
    @CheckReturnValue
    default public RoleManager setPermissions(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.setPermissions(Arrays.asList(permissions));
    }

    @Nonnull
    @CheckReturnValue
    default public RoleManager setPermissions(@Nonnull Collection<Permission> permissions) {
        Checks.noneNull(permissions, "Permissions");
        return this.setPermissions(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    default public RoleManager setColor(@Nullable Color color) {
        return this.setColor(color == null ? 0x1FFFFFFF : color.getRGB());
    }

    @Nonnull
    @CheckReturnValue
    public RoleManager setColor(int var1);

    @Nonnull
    @CheckReturnValue
    public RoleManager setColors(@Nullable RoleColors var1);

    @Nonnull
    @CheckReturnValue
    default public RoleManager setGradientColors(@Nonnull Color primary, @Nonnull Color secondary) {
        Checks.notNull(primary, "Primary");
        Checks.notNull(secondary, "Secondary");
        return this.setGradientColors(primary.getRGB(), secondary.getRGB());
    }

    @Nonnull
    @CheckReturnValue
    public RoleManager setGradientColors(int var1, int var2);

    @Nonnull
    @CheckReturnValue
    public RoleManager useHolographicStyle();

    @Nonnull
    @CheckReturnValue
    public RoleManager setHoisted(boolean var1);

    @Nonnull
    @CheckReturnValue
    public RoleManager setMentionable(boolean var1);

    @Nonnull
    @CheckReturnValue
    public RoleManager setIcon(@Nullable Icon var1);

    @Nonnull
    @CheckReturnValue
    public RoleManager setIcon(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    default public RoleManager setIcon(@Nullable UnicodeEmoji emoji) {
        return this.setIcon(emoji == null ? null : emoji.getFormatted());
    }

    @Nonnull
    @CheckReturnValue
    default public RoleManager givePermissions(Permission ... perms) {
        Checks.notNull(perms, "Permissions");
        return this.givePermissions(Arrays.asList(perms));
    }

    @Nonnull
    @CheckReturnValue
    public RoleManager givePermissions(@Nonnull Collection<Permission> var1);

    @Nonnull
    @CheckReturnValue
    default public RoleManager revokePermissions(Permission ... perms) {
        Checks.notNull(perms, "Permissions");
        return this.revokePermissions(Arrays.asList(perms));
    }

    @Nonnull
    @CheckReturnValue
    public RoleManager revokePermissions(@Nonnull Collection<Permission> var1);
}

