/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.interactions.modals;

import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import de.staffchat.shaded.jda.api.entities.channel.unions.MessageChannelUnion;
import de.staffchat.shaded.jda.api.interactions.ICustomIdInteraction;
import de.staffchat.shaded.jda.api.interactions.callbacks.IMessageEditCallback;
import de.staffchat.shaded.jda.api.interactions.callbacks.IReplyCallback;
import de.staffchat.shaded.jda.api.interactions.modals.ModalMapping;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ModalInteraction
extends IReplyCallback,
IMessageEditCallback,
ICustomIdInteraction {
    @Override
    @Nonnull
    default public String getCustomId() {
        return this.getModalId();
    }

    @Nonnull
    public String getModalId();

    @Nonnull
    public @Unmodifiable List<ModalMapping> getValues();

    @Nullable
    default public ModalMapping getValue(@Nonnull String customId) {
        Checks.notNull(customId, "ID");
        return this.getValues().stream().filter(mapping -> mapping.getCustomId().equals(customId)).findFirst().orElse(null);
    }

    @Nullable
    default public ModalMapping getValueByUniqueId(int id) {
        return this.getValues().stream().filter(mapping -> mapping.getUniqueId() == id).findFirst().orElse(null);
    }

    @Nullable
    public Message getMessage();

    @Override
    @Nonnull
    public MessageChannelUnion getChannel();

    @Override
    @Nonnull
    default public GuildMessageChannelUnion getGuildChannel() {
        return (GuildMessageChannelUnion)IReplyCallback.super.getGuildChannel();
    }
}

