/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.interactions.components.buttons;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.buttons.Button;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.tree.MessageComponentTree;
import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.interactions.components.ComponentInteraction;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.api.requests.restaction.WebhookMessageEditAction;
import de.staffchat.shaded.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ButtonInteraction
extends ComponentInteraction {
    @Override
    @Nonnull
    default public Button getComponent() {
        return this.getButton();
    }

    @Nonnull
    public Button getButton();

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> editButton(@Nullable Button newButton) {
        Message message = this.getMessage();
        MessageComponentTree newTree = message.getComponentTree().replace(ComponentReplacer.byUniqueId(this.getButton(), (Component)newButton));
        if (this.isAcknowledged()) {
            return ((WebhookMessageEditAction)this.getHook().editMessageComponentsById(message.getId(), newTree.getComponents()).useComponentsV2(message.isUsingComponentsV2())).map(it -> null);
        }
        return ((MessageEditCallbackAction)this.editComponents(newTree.getComponents()).useComponentsV2(message.isUsingComponentsV2())).map(it -> null);
    }
}

