/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.interactions.callbacks;

import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.tree.ComponentTree;
import de.staffchat.shaded.jda.api.entities.MessageEmbed;
import de.staffchat.shaded.jda.api.interactions.callbacks.IDeferrableCallback;
import de.staffchat.shaded.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import de.staffchat.shaded.jda.api.utils.AttachedFile;
import de.staffchat.shaded.jda.api.utils.messages.MessageEditData;
import de.staffchat.shaded.jda.internal.requests.restaction.interactions.MessageEditCallbackActionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface IMessageEditCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction deferEdit();

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessage(@Nonnull MessageEditData message) {
        Checks.notNull(message, "Message");
        MessageEditCallbackActionImpl action = (MessageEditCallbackActionImpl)this.deferEdit();
        return (MessageEditCallbackAction)action.applyData(message);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessage(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return (MessageEditCallbackAction)this.deferEdit().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editComponents(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        Checks.noneNull(components, "Components");
        return (MessageEditCallbackAction)this.deferEdit().setComponents(components);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editComponents(MessageTopLevelComponent ... components) {
        Checks.noneNull(components, "components");
        return this.editComponents(Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.editComponents(tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return (MessageEditCallbackAction)this.deferEdit().setEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageEmbeds(MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return (MessageEditCallbackAction)this.deferEdit().setEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format String");
        return this.editMessage(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageAttachments(@Nonnull Collection<? extends AttachedFile> attachments) {
        Checks.noneNull(attachments, "Attachments");
        return (MessageEditCallbackAction)this.deferEdit().setAttachments(attachments);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageAttachments(AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return (MessageEditCallbackAction)this.deferEdit().setAttachments(attachments);
    }
}

