/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.interactions;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.Entitlement;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.ISnowflake;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.channel.Channel;
import de.staffchat.shaded.jda.api.entities.channel.ChannelType;
import de.staffchat.shaded.jda.api.entities.channel.middleman.GuildChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.interactions.DiscordLocale;
import de.staffchat.shaded.jda.api.interactions.IntegrationOwners;
import de.staffchat.shaded.jda.api.interactions.InteractionContextType;
import de.staffchat.shaded.jda.api.interactions.InteractionType;
import de.staffchat.shaded.jda.internal.utils.ChannelUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Interaction
extends ISnowflake {
    public int getTypeRaw();

    @Nonnull
    default public InteractionType getType() {
        return InteractionType.fromKey(this.getTypeRaw());
    }

    @Nonnull
    public String getToken();

    @Nullable
    public Guild getGuild();

    default public boolean isFromAttachedGuild() {
        Guild guild = this.getGuild();
        if (guild == null) {
            return false;
        }
        return !guild.isDetached();
    }

    default public boolean isFromGuild() {
        return this.getGuild() != null;
    }

    @Nonnull
    default public ChannelType getChannelType() {
        Channel channel = this.getChannel();
        return channel != null ? channel.getType() : ChannelType.UNKNOWN;
    }

    @Nonnull
    public User getUser();

    @Nullable
    public Member getMember();

    public boolean isAcknowledged();

    @Nullable
    public Channel getChannel();

    public long getChannelIdLong();

    @Nullable
    default public String getChannelId() {
        long id = this.getChannelIdLong();
        return id != 0L ? Long.toUnsignedString(this.getChannelIdLong()) : null;
    }

    @Nonnull
    default public GuildChannel getGuildChannel() {
        return ChannelUtil.safeChannelCast(this.getChannel(), GuildChannel.class);
    }

    @Nonnull
    default public MessageChannel getMessageChannel() {
        return ChannelUtil.safeChannelCast(this.getChannel(), MessageChannel.class);
    }

    @Nonnull
    public DiscordLocale getUserLocale();

    @Nonnull
    default public DiscordLocale getGuildLocale() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This interaction did not happen in a guild");
        }
        return this.getGuild().getLocale();
    }

    @Nonnull
    public List<Entitlement> getEntitlements();

    @Nonnull
    public InteractionContextType getContext();

    @Nonnull
    public IntegrationOwners getIntegrationOwners();

    @Nonnull
    public JDA getJDA();
}

