/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities.emoji;

import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.Role;
import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.entities.emoji.CustomEmoji;
import de.staffchat.shaded.jda.api.managers.CustomEmojiManager;
import de.staffchat.shaded.jda.api.requests.restaction.AuditableRestAction;
import de.staffchat.shaded.jda.api.requests.restaction.CacheRestAction;
import de.staffchat.shaded.jda.internal.utils.PermissionUtil;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface RichCustomEmoji
extends CustomEmoji {
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public @Unmodifiable List<Role> getRoles();

    public boolean isManaged();

    public boolean isAvailable();

    @Nonnull
    public JDA getJDA();

    @Nullable
    public User getOwner();

    @Nonnull
    @CheckReturnValue
    public CacheRestAction<User> retrieveOwner();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public CustomEmojiManager getManager();

    default public boolean canInteract(@Nonnull Member issuer) {
        return PermissionUtil.canInteract(issuer, this);
    }

    default public boolean canInteract(@Nonnull User issuer, @Nonnull MessageChannel channel) {
        return PermissionUtil.canInteract(issuer, this, channel);
    }

    default public boolean canInteract(@Nonnull User issuer, @Nonnull MessageChannel channel, boolean botOverride) {
        return PermissionUtil.canInteract(issuer, this, channel, botOverride);
    }
}

