/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities.channel.concrete;

import de.staffchat.shaded.jda.api.Permission;
import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Message;
import de.staffchat.shaded.jda.api.entities.SelfMember;
import de.staffchat.shaded.jda.api.entities.Webhook;
import de.staffchat.shaded.jda.api.entities.channel.concrete.TextChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.GuildChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import de.staffchat.shaded.jda.api.exceptions.InsufficientPermissionException;
import de.staffchat.shaded.jda.api.managers.channel.concrete.NewsChannelManager;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.ChannelAction;
import de.staffchat.shaded.jda.internal.requests.RestActionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface NewsChannel
extends StandardGuildMessageChannel {
    @Nonnull
    @CheckReturnValue
    public RestAction<Webhook.WebhookReference> follow(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Webhook.WebhookReference> follow(long targetChannelId) {
        return this.follow(Long.toUnsignedString(targetChannelId));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Webhook.WebhookReference> follow(@Nonnull TextChannel targetChannel) {
        Checks.notNull(targetChannel, "Target Channel");
        SelfMember selfMember = targetChannel.getGuild().getSelfMember();
        Checks.checkAccess(selfMember, targetChannel);
        if (!selfMember.hasPermission((GuildChannel)targetChannel, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(targetChannel, Permission.MANAGE_WEBHOOKS);
        }
        return this.follow(targetChannel.getId());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> crosspostMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId);
        Checks.checkAccess(this.getGuild().getSelfMember(), this);
        Checks.checkAttached(this);
        Route.CompiledRoute route = Route.Messages.CROSSPOST_MESSAGE.compile(this.getId(), messageId);
        return new RestActionImpl<Message>(this.getJDA(), route, (response, request) -> request.getJDA().getEntityBuilder().createMessageWithChannel(response.getObject(), this, false));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> crosspostMessageById(long messageId) {
        return this.crosspostMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public ChannelAction<NewsChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    @CheckReturnValue
    default public ChannelAction<NewsChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public NewsChannelManager getManager();
}

