/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities.channel.concrete;

import de.staffchat.shaded.jda.api.entities.User;
import de.staffchat.shaded.jda.api.entities.channel.middleman.MessageChannel;
import de.staffchat.shaded.jda.api.entities.detached.IDetachableEntity;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.api.utils.ImageProxy;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GroupChannel
extends MessageChannel,
IDetachableEntity {
    public static final String ICON_URL = "https://cdn.discordapp.com/channel-icons/%s/%s.png";

    @Nullable
    public String getIconId();

    @Nullable
    default public String getIconUrl() {
        String iconId = this.getIconId();
        return iconId == null ? null : Helpers.format(ICON_URL, this.getId(), iconId);
    }

    @Nullable
    default public ImageProxy getIcon() {
        String iconUrl = this.getIconUrl();
        return iconUrl == null ? null : new ImageProxy(iconUrl);
    }

    public long getOwnerIdLong();

    @Nonnull
    default public String getOwnerId() {
        return Long.toUnsignedString(this.getOwnerIdLong());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<User> retrieveOwner() {
        return this.getJDA().retrieveUserById(this.getOwnerIdLong());
    }
}

