/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities.channel.attribute;

import de.staffchat.shaded.jda.api.entities.channel.attribute.IPermissionContainer;
import de.staffchat.shaded.jda.api.entities.channel.concrete.ThreadChannel;
import de.staffchat.shaded.jda.api.entities.channel.middleman.GuildChannel;
import de.staffchat.shaded.jda.api.requests.restaction.ThreadChannelAction;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import de.staffchat.shaded.jda.api.utils.MiscUtil;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface IThreadContainer
extends GuildChannel,
IPermissionContainer {
    public int getDefaultThreadSlowmode();

    @Nonnull
    default public @Unmodifiable List<ThreadChannel> getThreadChannels() {
        return this.getGuild().getThreadChannelCache().applyStream(stream -> stream.filter(thread -> thread.getParentChannel() == this).collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name) {
        return this.createThreadChannel(name, false);
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, boolean var2);

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, long var2);

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name, @Nonnull String messageId) {
        return this.createThreadChannel(name, MiscUtil.parseSnowflake(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPublicThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateJoinedThreadChannels();
}

