/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities;

import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.ISnowflake;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.channel.concrete.StageChannel;
import de.staffchat.shaded.jda.api.managers.StageInstanceManager;
import de.staffchat.shaded.jda.api.requests.RestAction;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface StageInstance
extends ISnowflake {
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public StageChannel getChannel();

    @Nonnull
    public String getTopic();

    @Nonnull
    public PrivacyLevel getPrivacyLevel();

    @Nonnull
    default public @Unmodifiable List<Member> getSpeakers() {
        return this.getChannel().getMembers().stream().filter(member -> !member.getVoiceState().isSuppressed()).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    default public @Unmodifiable List<Member> getAudience() {
        return this.getChannel().getMembers().stream().filter(member -> member.getVoiceState().isSuppressed()).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public StageInstanceManager getManager();

    public static enum PrivacyLevel {
        UNKNOWN(-1),
        GUILD_ONLY(2);

        private final int key;

        private PrivacyLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static PrivacyLevel fromKey(int key) {
            for (PrivacyLevel level : PrivacyLevel.values()) {
                if (level.key != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }
}

