/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.entities;

import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.api.utils.data.SerializableData;
import de.staffchat.shaded.jda.internal.utils.EntityString;
import java.awt.Color;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RoleColors
implements SerializableData {
    public static final RoleColors DEFAULT_HOLOGRAPHIC = new RoleColors(11127295, 16759788, 16761760);
    public static final RoleColors DEFAULT = new RoleColors(0x1FFFFFFF, 0x1FFFFFFF, 0x1FFFFFFF);
    private final int primary;
    private final int secondary;
    private final int tertiary;

    public RoleColors(int primary, int secondary, int tertiary) {
        this.primary = primary;
        this.secondary = secondary;
        this.tertiary = tertiary;
    }

    public boolean isDefault() {
        return this.primary == 0x1FFFFFFF;
    }

    public boolean isSolid() {
        return this.primary != 0x1FFFFFFF && this.secondary == 0x1FFFFFFF && this.tertiary == 0x1FFFFFFF;
    }

    public boolean isGradient() {
        return this.tertiary == 0x1FFFFFFF && this.secondary != 0x1FFFFFFF && this.primary != 0x1FFFFFFF;
    }

    public boolean isHolographic() {
        return this.equals(DEFAULT_HOLOGRAPHIC);
    }

    @Nullable
    public Color getPrimary() {
        return this.primary == 0x1FFFFFFF ? null : new Color(this.primary);
    }

    public int getPrimaryRaw() {
        return this.primary;
    }

    @Nullable
    public Color getSecondary() {
        return this.secondary == 0x1FFFFFFF ? null : new Color(this.secondary);
    }

    public int getSecondaryRaw() {
        return this.secondary;
    }

    @Nullable
    public Color getTertiary() {
        return this.tertiary == 0x1FFFFFFF ? null : new Color(this.tertiary);
    }

    public int getTertiaryRaw() {
        return this.tertiary;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoleColors)) {
            return false;
        }
        RoleColors other = (RoleColors)obj;
        return this.primary == other.primary && this.secondary == other.secondary && this.tertiary == other.tertiary;
    }

    public int hashCode() {
        return Objects.hash(this.primary, this.secondary, this.tertiary);
    }

    public String toString() {
        return new EntityString(this).addMetadata("primary", RoleColors.colorToHex(this.primary)).addMetadata("secondary", RoleColors.colorToHex(this.secondary)).addMetadata("tertiary", RoleColors.colorToHex(this.tertiary)).toString();
    }

    private static String colorToHex(int color) {
        return color == 0x1FFFFFFF ? null : Integer.toHexString(color);
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("primary_color", this.primary != 0x1FFFFFFF ? this.primary & 0xFFFFFF : 0).put("secondary_color", this.secondary != 0x1FFFFFFF ? Integer.valueOf(this.secondary & 0xFFFFFF) : null).put("tertiary_color", this.tertiary != 0x1FFFFFFF ? Integer.valueOf(this.tertiary & 0xFFFFFF) : null);
    }
}

