/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.utils;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.IComponentUnion;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.ModalTopLevelComponent;
import de.staffchat.shaded.jda.api.components.filedisplay.FileDisplay;
import de.staffchat.shaded.jda.api.components.mediagallery.MediaGallery;
import de.staffchat.shaded.jda.api.components.mediagallery.MediaGalleryItem;
import de.staffchat.shaded.jda.api.components.thumbnail.Thumbnail;
import de.staffchat.shaded.jda.api.components.tree.ComponentTree;
import de.staffchat.shaded.jda.api.components.tree.MessageComponentTree;
import de.staffchat.shaded.jda.api.components.tree.ModalComponentTree;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.components.UnknownComponentImpl;
import de.staffchat.shaded.jda.internal.components.actionrow.ActionRowImpl;
import de.staffchat.shaded.jda.internal.components.attachmentupload.AttachmentUploadImpl;
import de.staffchat.shaded.jda.internal.components.buttons.ButtonImpl;
import de.staffchat.shaded.jda.internal.components.container.ContainerImpl;
import de.staffchat.shaded.jda.internal.components.filedisplay.FileDisplayFileUpload;
import de.staffchat.shaded.jda.internal.components.filedisplay.FileDisplayImpl;
import de.staffchat.shaded.jda.internal.components.label.LabelImpl;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryImpl;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryItemFileUpload;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryItemImpl;
import de.staffchat.shaded.jda.internal.components.section.SectionImpl;
import de.staffchat.shaded.jda.internal.components.selections.EntitySelectMenuImpl;
import de.staffchat.shaded.jda.internal.components.selections.StringSelectMenuImpl;
import de.staffchat.shaded.jda.internal.components.separator.SeparatorImpl;
import de.staffchat.shaded.jda.internal.components.textdisplay.TextDisplayImpl;
import de.staffchat.shaded.jda.internal.components.textinput.TextInputImpl;
import de.staffchat.shaded.jda.internal.components.thumbnail.ThumbnailFileUpload;
import de.staffchat.shaded.jda.internal.components.thumbnail.ThumbnailImpl;
import de.staffchat.shaded.jda.internal.components.utils.ComponentsUtil;
import de.staffchat.shaded.jda.internal.utils.Checks;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ComponentDeserializer {
    private static final String ATTACHMENT_SCHEMA = "attachment://";
    private final Map<String, FileUpload> files;

    public ComponentDeserializer(@Nonnull Collection<? extends FileUpload> files) {
        this.files = new LinkedHashMap<String, FileUpload>(files.size());
        for (FileUpload fileUpload : files) {
            this.files.put(fileUpload.getName(), fileUpload);
        }
    }

    @Nonnull
    public List<IComponentUnion> deserializeAll(@Nonnull List<DataObject> components) {
        Checks.noneNull(components, "Components");
        return components.stream().map(this::parseComponent).collect(Collectors.toList());
    }

    @Nonnull
    public <T extends Component> Stream<T> deserializeAs(@Nonnull Class<T> type, @Nonnull List<DataObject> components) {
        Checks.notNull(type, "Type");
        Checks.noneNull(components, "Components");
        return components.stream().map(this::parseComponent).map(component -> ComponentsUtil.safeUnionCastWithUnknownType("component", component, type));
    }

    @Nonnull
    public <T extends Component> Stream<T> deserializeAs(@Nonnull Class<T> type, @Nonnull DataArray components) {
        Checks.notNull(type, "Type");
        Checks.notNull(components, "Components");
        return components.stream(DataArray::getObject).map(this::parseComponent).map(component -> ComponentsUtil.safeUnionCastWithUnknownType("component", component, type));
    }

    @Nonnull
    public <T extends Component> T deserializeAs(@Nonnull Class<T> type, @Nonnull DataObject component) {
        Checks.notNull(type, "Type");
        Checks.notNull(component, "Component");
        IComponentUnion componentUnion = this.parseComponent(component);
        return ComponentsUtil.safeUnionCastWithUnknownType("component", componentUnion, type);
    }

    @Nonnull
    public <T extends ComponentTree<?>> T deserializeAsTree(@Nonnull Class<T> treeType, @Nonnull List<DataObject> components) {
        Checks.notNull(components, "Components");
        return this.deserializeAsTree(treeType, DataArray.fromCollection(components));
    }

    @Nonnull
    public <T extends ComponentTree<?>> T deserializeAsTree(@Nonnull Class<T> treeType, @Nonnull DataArray components) {
        Checks.notNull(treeType, "Tree type");
        Checks.notNull(components, "Components");
        if (MessageComponentTree.class.isAssignableFrom(treeType)) {
            return (T)MessageComponentTree.of(this.deserializeAs(MessageTopLevelComponent.class, components).collect(Collectors.toList()));
        }
        if (ModalComponentTree.class.isAssignableFrom(treeType)) {
            return (T)ModalComponentTree.of(this.deserializeAs(ModalTopLevelComponent.class, components).collect(Collectors.toList()));
        }
        if (ComponentTree.class.isAssignableFrom(treeType)) {
            return (T)ComponentTree.of(this.deserializeAs(Component.class, components).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("Cannot deserialize to tree of type " + treeType.getName());
    }

    @Nonnull
    private IComponentUnion parseComponent(@Nonnull DataObject data) {
        switch (Component.Type.fromKey(data.getInt("type"))) {
            case ACTION_ROW: {
                return new ActionRowImpl(this, data);
            }
            case BUTTON: {
                return new ButtonImpl(data);
            }
            case STRING_SELECT: {
                return new StringSelectMenuImpl(data);
            }
            case TEXT_INPUT: {
                return new TextInputImpl(data);
            }
            case USER_SELECT: 
            case ROLE_SELECT: 
            case MENTIONABLE_SELECT: 
            case CHANNEL_SELECT: {
                return new EntitySelectMenuImpl(data);
            }
            case SECTION: {
                return new SectionImpl(this, data);
            }
            case TEXT_DISPLAY: {
                return new TextDisplayImpl(data);
            }
            case THUMBNAIL: {
                return (IComponentUnion)((Object)this.toThumbnail(data));
            }
            case MEDIA_GALLERY: {
                return (IComponentUnion)((Object)this.toMediaGallery(data));
            }
            case FILE_DISPLAY: {
                return (IComponentUnion)((Object)this.toFileDisplay(data));
            }
            case SEPARATOR: {
                return new SeparatorImpl(data);
            }
            case CONTAINER: {
                return new ContainerImpl(this, data);
            }
            case LABEL: {
                return new LabelImpl(this, data);
            }
            case FILE_UPLOAD: {
                return new AttachmentUploadImpl(data);
            }
        }
        return new UnknownComponentImpl(data);
    }

    @Nonnull
    private Thumbnail toThumbnail(@Nonnull DataObject data) {
        String url = data.getObject("media").getString("url");
        if (url.startsWith(ATTACHMENT_SCHEMA)) {
            return new ThumbnailFileUpload(data.getInt("id", -1), this.getFileByUri(url), data.getString("description", null), data.getBoolean("spoiler"));
        }
        return new ThumbnailImpl(data);
    }

    @Nonnull
    private FileDisplay toFileDisplay(@Nonnull DataObject data) {
        String url = data.getObject("file").getString("url");
        if (url.startsWith(ATTACHMENT_SCHEMA)) {
            return new FileDisplayFileUpload(data.getInt("id", -1), this.getFileByUri(url), data.getBoolean("spoiler"));
        }
        return new FileDisplayImpl(data);
    }

    @Nonnull
    private MediaGallery toMediaGallery(@Nonnull DataObject data) {
        return new MediaGalleryImpl(data.getInt("id", -1), data.getArray("items").stream(DataArray::getObject).map(this::toMediaGalleryItem).collect(Collectors.toList()));
    }

    @Nonnull
    private MediaGalleryItem toMediaGalleryItem(@Nonnull DataObject data) {
        String url = data.getObject("media").getString("url");
        if (url.startsWith(ATTACHMENT_SCHEMA)) {
            return new MediaGalleryItemFileUpload(this.getFileByUri(url), data.getString("description", null), data.getBoolean("spoiler"));
        }
        return new MediaGalleryItemImpl(data);
    }

    @Nonnull
    private FileUpload getFileByUri(@Nonnull String uri) {
        String name = uri.substring(ATTACHMENT_SCHEMA.length());
        FileUpload file = this.files.get(name);
        Checks.check(file != null, "File for URI %s is missing", (Object)uri);
        return file;
    }
}

