/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.thumbnail;

import de.staffchat.shaded.jda.api.components.ResolvedMedia;
import de.staffchat.shaded.jda.api.components.section.SectionAccessoryComponent;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.internal.components.thumbnail.ThumbnailFileUpload;
import de.staffchat.shaded.jda.internal.components.thumbnail.ThumbnailImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Thumbnail
extends SectionAccessoryComponent {
    public static final int MAX_DESCRIPTION_LENGTH = 1024;

    @Nonnull
    public static Thumbnail fromUrl(@Nonnull String url) {
        Checks.notBlank(url, "URL");
        return new ThumbnailImpl(url);
    }

    @Nonnull
    public static Thumbnail fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new ThumbnailFileUpload(file);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Thumbnail withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public Thumbnail withDescription(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public Thumbnail withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    @Nullable
    public String getDescription();

    public boolean isSpoiler();
}

