/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.textdisplay;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.ModalTopLevelComponent;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.section.SectionContentComponent;
import de.staffchat.shaded.jda.internal.components.textdisplay.TextDisplayImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface TextDisplay
extends Component,
MessageTopLevelComponent,
ModalTopLevelComponent,
ContainerChildComponent,
SectionContentComponent {
    @Nonnull
    public static TextDisplay of(@Nonnull String content) {
        Checks.notBlank(content, "Content");
        return new TextDisplayImpl(content);
    }

    @Nonnull
    public static TextDisplay ofFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format string");
        Checks.notNull(args, "Format args");
        return TextDisplay.of(String.format(format, args));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TextDisplay withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public TextDisplay withContent(@Nonnull String var1);

    @Nonnull
    public String getContent();
}

