/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.section;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.attribute.IDisableable;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.replacer.IReplaceable;
import de.staffchat.shaded.jda.api.components.section.SectionAccessoryComponent;
import de.staffchat.shaded.jda.api.components.section.SectionAccessoryComponentUnion;
import de.staffchat.shaded.jda.api.components.section.SectionContentComponent;
import de.staffchat.shaded.jda.api.components.section.SectionContentComponentUnion;
import de.staffchat.shaded.jda.api.components.utils.ComponentIterator;
import de.staffchat.shaded.jda.internal.components.section.SectionImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface Section
extends MessageTopLevelComponent,
ContainerChildComponent,
IReplaceable,
IDisableable {
    public static final int MAX_COMPONENTS = 3;

    @Nonnull
    public static Section of(@Nonnull SectionAccessoryComponent accessory, @Nonnull Collection<? extends SectionContentComponent> components) {
        return SectionImpl.validated(accessory, components);
    }

    @Nonnull
    public static Section of(@Nonnull SectionAccessoryComponent accessory, @Nonnull SectionContentComponent component, SectionContentComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.noneNull(components, "Components");
        return Section.of(accessory, Helpers.mergeVararg(component, components));
    }

    @Override
    default public boolean isMessageCompatible() {
        if (!this.getType().isMessageCompatible()) {
            return false;
        }
        return this.getContentComponents().stream().allMatch(Component::isMessageCompatible) && this.getAccessory().isMessageCompatible();
    }

    @Override
    default public boolean isModalCompatible() {
        if (!this.getType().isModalCompatible()) {
            return false;
        }
        return this.getContentComponents().stream().allMatch(Component::isModalCompatible) && this.getAccessory().isModalCompatible();
    }

    @Override
    @Nonnull
    public Section replace(@Nonnull ComponentReplacer var1);

    @Override
    @Nonnull
    @CheckReturnValue
    public Section withUniqueId(int var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public Section withDisabled(boolean disabled) {
        return this.replace(ComponentReplacer.of(IDisableable.class, (? super T c) -> true, (? super T c) -> c.withDisabled(disabled)));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public Section asDisabled() {
        return (Section)IDisableable.super.asDisabled();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public Section asEnabled() {
        return (Section)IDisableable.super.asEnabled();
    }

    @Nonnull
    @CheckReturnValue
    public Section withContentComponents(@Nonnull Collection<? extends SectionContentComponent> var1);

    @Nonnull
    @CheckReturnValue
    default public Section withContentComponents(@Nonnull SectionContentComponent component, SectionContentComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.notNull(components, "Components");
        return this.withContentComponents(Helpers.mergeVararg(component, components));
    }

    @Nonnull
    @CheckReturnValue
    public Section withAccessory(@Nonnull SectionAccessoryComponent var1);

    @Nonnull
    public @Unmodifiable List<SectionContentComponentUnion> getContentComponents();

    @Nonnull
    public SectionAccessoryComponentUnion getAccessory();

    @Override
    default public boolean isDisabled() {
        SectionAccessoryComponentUnion accessory = this.getAccessory();
        if (accessory instanceof IDisableable && ((IDisableable)((Object)accessory)).isEnabled()) {
            return false;
        }
        return ComponentIterator.createStream(this.getContentComponents()).filter(IDisableable.class::isInstance).map(IDisableable.class::cast).allMatch(IDisableable::isDisabled);
    }

    @Override
    default public boolean isEnabled() {
        SectionAccessoryComponentUnion accessory = this.getAccessory();
        if (accessory instanceof IDisableable && ((IDisableable)((Object)accessory)).isDisabled()) {
            return false;
        }
        return ComponentIterator.createStream(this.getContentComponents()).filter(IDisableable.class::isInstance).map(IDisableable.class::cast).allMatch(IDisableable::isEnabled);
    }
}

