/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.mediagallery;

import de.staffchat.shaded.jda.api.components.ResolvedMedia;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryItemFileUpload;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryItemImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MediaGalleryItem {
    public static final int MAX_DESCRIPTION_LENGTH = 1024;

    @Nonnull
    public static MediaGalleryItem fromUrl(@Nonnull String url) {
        Checks.notBlank(url, "URL");
        return new MediaGalleryItemImpl(url);
    }

    @Nonnull
    public static MediaGalleryItem fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new MediaGalleryItemFileUpload(file);
    }

    @Nonnull
    @CheckReturnValue
    public MediaGalleryItem withDescription(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public MediaGalleryItem withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    @Nullable
    public String getDescription();

    public boolean isSpoiler();
}

