/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.mediagallery;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.mediagallery.MediaGalleryItem;
import de.staffchat.shaded.jda.internal.components.mediagallery.MediaGalleryImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface MediaGallery
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    public static final int MAX_ITEMS = 10;

    @Nonnull
    public static MediaGallery of(@Nonnull Collection<? extends MediaGalleryItem> items) {
        return MediaGalleryImpl.validated(items);
    }

    @Nonnull
    public static MediaGallery of(@Nonnull MediaGalleryItem item, MediaGalleryItem ... items) {
        Checks.notNull(item, "Item");
        Checks.noneNull(items, "Items");
        return MediaGallery.of(Helpers.mergeVararg(item, items));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MediaGallery withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public MediaGallery withItems(@Nonnull Collection<? extends MediaGalleryItem> var1);

    @Nonnull
    @CheckReturnValue
    default public MediaGallery withItems(@Nonnull MediaGalleryItem item, MediaGalleryItem ... items) {
        Checks.notNull(item, "Item");
        Checks.notNull(items, "Items");
        return this.withItems(Helpers.mergeVararg(item, items));
    }

    @Nonnull
    public @Unmodifiable List<MediaGalleryItem> getItems();
}

