/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.filedisplay;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.ResolvedMedia;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.utils.FileUpload;
import de.staffchat.shaded.jda.internal.components.filedisplay.FileDisplayFileUpload;
import de.staffchat.shaded.jda.internal.components.filedisplay.FileDisplayImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface FileDisplay
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    @Nonnull
    public static FileDisplay fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new FileDisplayFileUpload(file);
    }

    @Nonnull
    public static FileDisplay fromFileName(@Nonnull String fileName) {
        Checks.notNull(fileName, "File name");
        return new FileDisplayImpl("attachment://" + fileName);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public FileDisplay withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public FileDisplay withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    public boolean isSpoiler();
}

