/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.container;

import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.attribute.IDisableable;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponentUnion;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.replacer.IReplaceable;
import de.staffchat.shaded.jda.api.components.utils.ComponentIterator;
import de.staffchat.shaded.jda.internal.components.container.ContainerImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface Container
extends MessageTopLevelComponent,
IReplaceable,
IDisableable {
    @Nonnull
    public static Container of(@Nonnull Collection<? extends ContainerChildComponent> components) {
        return ContainerImpl.validated(components);
    }

    @Nonnull
    public static Container of(@Nonnull ContainerChildComponent component, ContainerChildComponent ... components) {
        return Container.of(Helpers.mergeVararg(component, components));
    }

    @Override
    default public boolean isMessageCompatible() {
        if (!this.getType().isMessageCompatible()) {
            return false;
        }
        return this.getComponents().stream().allMatch(Component::isMessageCompatible);
    }

    @Override
    default public boolean isModalCompatible() {
        if (!this.getType().isModalCompatible()) {
            return false;
        }
        return this.getComponents().stream().allMatch(Component::isModalCompatible);
    }

    @Override
    @Nonnull
    public Container replace(@Nonnull ComponentReplacer var1);

    @Override
    @Nonnull
    @CheckReturnValue
    public Container withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public Container withAccentColor(@Nullable Integer var1);

    @Nonnull
    @CheckReturnValue
    default public Container withAccentColor(@Nullable Color accentColor) {
        return this.withAccentColor(accentColor == null ? null : Integer.valueOf(accentColor.getRGB()));
    }

    @Nonnull
    @CheckReturnValue
    public Container withSpoiler(boolean var1);

    @Nonnull
    @CheckReturnValue
    public Container withComponents(@Nonnull Collection<? extends ContainerChildComponent> var1);

    @Nonnull
    @CheckReturnValue
    default public Container withComponents(@Nonnull ContainerChildComponent component, ContainerChildComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.notNull(components, "Components");
        return this.withComponents(Helpers.mergeVararg(component, components));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public Container withDisabled(boolean disabled) {
        return this.replace(ComponentReplacer.of(IDisableable.class, (? super T c) -> true, (? super T c) -> c.withDisabled(disabled)));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public Container asDisabled() {
        return (Container)IDisableable.super.asDisabled();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public Container asEnabled() {
        return (Container)IDisableable.super.asEnabled();
    }

    @Nonnull
    public @Unmodifiable List<ContainerChildComponentUnion> getComponents();

    @Override
    default public boolean isDisabled() {
        return ComponentIterator.createStream(this.getComponents()).filter(IDisableable.class::isInstance).map(IDisableable.class::cast).allMatch(IDisableable::isDisabled);
    }

    @Override
    default public boolean isEnabled() {
        return ComponentIterator.createStream(this.getComponents()).filter(IDisableable.class::isInstance).map(IDisableable.class::cast).allMatch(IDisableable::isEnabled);
    }

    @Nullable
    default public Color getAccentColor() {
        return this.getAccentColorRaw() != null ? new Color(this.getAccentColorRaw()) : null;
    }

    @Nullable
    public Integer getAccentColorRaw();

    public boolean isSpoiler();
}

