/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.api.components.actionrow;

import de.staffchat.shaded.jda.api.components.ActionComponent;
import de.staffchat.shaded.jda.api.components.Component;
import de.staffchat.shaded.jda.api.components.MessageTopLevelComponent;
import de.staffchat.shaded.jda.api.components.actionrow.ActionRowChildComponent;
import de.staffchat.shaded.jda.api.components.actionrow.ActionRowChildComponentUnion;
import de.staffchat.shaded.jda.api.components.attribute.IDisableable;
import de.staffchat.shaded.jda.api.components.buttons.Button;
import de.staffchat.shaded.jda.api.components.container.ContainerChildComponent;
import de.staffchat.shaded.jda.api.components.replacer.ComponentReplacer;
import de.staffchat.shaded.jda.api.components.replacer.IReplaceable;
import de.staffchat.shaded.jda.internal.components.actionrow.ActionRowImpl;
import de.staffchat.shaded.jda.internal.utils.Checks;
import de.staffchat.shaded.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface ActionRow
extends MessageTopLevelComponent,
ContainerChildComponent,
IReplaceable,
IDisableable {
    @Nonnull
    public static ActionRow of(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        return ActionRowImpl.validated(components);
    }

    @Nonnull
    public static ActionRow of(@Nonnull ActionRowChildComponent component, ActionRowChildComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.notNull(components, "Components");
        return ActionRow.of(Helpers.mergeVararg(component, components));
    }

    @Nonnull
    public static List<ActionRow> partitionOf(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        return ActionRowImpl.partitionOf(components);
    }

    @Nonnull
    public static List<ActionRow> partitionOf(@Nonnull ActionRowChildComponent component, ActionRowChildComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.notNull(components, "Components");
        return ActionRow.partitionOf(Helpers.mergeVararg(component, components));
    }

    public static int getMaxAllowed(@Nonnull Component.Type type) {
        switch (type) {
            case BUTTON: {
                return 5;
            }
            case STRING_SELECT: 
            case USER_SELECT: 
            case ROLE_SELECT: 
            case MENTIONABLE_SELECT: 
            case CHANNEL_SELECT: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public ActionRow withUniqueId(int var1);

    @Nonnull
    public @Unmodifiable List<ActionRowChildComponentUnion> getComponents();

    @Nonnull
    default public @Unmodifiable List<ActionComponent> getActionComponents() {
        return this.getComponents().stream().filter(ActionComponent.class::isInstance).map(ActionComponent.class::cast).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    default public @Unmodifiable List<Button> getButtons() {
        return this.getComponents().stream().filter(Button.class::isInstance).map(Button.class::cast).collect(Helpers.toUnmodifiableList());
    }

    @Override
    default public boolean isMessageCompatible() {
        if (!this.getType().isMessageCompatible()) {
            return false;
        }
        return this.getComponents().stream().allMatch(Component::isMessageCompatible);
    }

    @Override
    default public boolean isModalCompatible() {
        if (!this.getType().isModalCompatible()) {
            return false;
        }
        return this.getComponents().stream().allMatch(Component::isModalCompatible);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public ActionRow replace(@Nonnull ComponentReplacer var1);

    @Override
    default public boolean isDisabled() {
        return this.getActionComponents().stream().allMatch(ActionComponent::isDisabled);
    }

    @Override
    default public boolean isEnabled() {
        return this.getActionComponents().stream().noneMatch(ActionComponent::isDisabled);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ActionRow withDisabled(boolean disabled) {
        return this.replace(ComponentReplacer.of(IDisableable.class, (? super T c) -> true, (? super T c) -> c.withDisabled(disabled)));
    }

    @Override
    @Nonnull
    default public ActionRow asDisabled() {
        return (ActionRow)IDisableable.super.asDisabled();
    }

    @Override
    @Nonnull
    default public ActionRow asEnabled() {
        return (ActionRow)IDisableable.super.asEnabled();
    }

    @Nonnull
    @CheckReturnValue
    public ActionRow withComponents(@Nonnull Collection<? extends ActionRowChildComponent> var1);

    @Nonnull
    @CheckReturnValue
    default public ActionRow withComponents(@Nonnull ActionRowChildComponent component, ActionRowChildComponent ... components) {
        Checks.notNull(component, "Component");
        Checks.notNull(components, "Components");
        return this.withComponents(Helpers.mergeVararg(component, components));
    }
}

