/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat;

import com.google.inject.Inject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.staffchat.DiscordBot;
import de.staffchat.shaded.jda.api.JDA;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Plugin(id="staffchat", name="StaffChat", version="1.1.0", description="A Velocity staff chat plugin", authors={"SimolZimol"})
public class StaffChatPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private Map<String, Object> config;
    private String permission;
    private String prefix;
    private String format;
    private final Set<UUID> mutedPlayers = new HashSet<UUID>();
    private boolean discordEnabled = false;
    private String discordToken = "";
    private String discordChannelId = "";
    private String discordFormat = "**[STAFF] {player}:** {message}";
    private String minecraftFormat = "&8[&4&lSTAFF&8][D]&r &b{discord_user}&7: &f{message}";
    private String toggleOnMessage = "";
    private String toggleOffMessage = "";
    private JDA jda;
    private DiscordBot discordBot;
    private static final LegacyComponentSerializer COLOR_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    @Inject
    public StaffChatPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.loadConfig();
        this.toggleOnMessage = this.getString("toggle_on_message", "&aStaff chat messages enabled.");
        this.toggleOffMessage = this.getString("toggle_off_message", "&cStaff chat messages disabled.");
        this.registerStaffChatCommand("sc");
        this.registerStaffChatCommand("staffchat");
        this.registerStaffChatCommand("s");
        this.registerStaffChatCommand("a");
        this.registerToggleCommand();
        if (this.discordEnabled && !this.discordToken.isEmpty() && !this.discordChannelId.isEmpty()) {
            this.discordBot = new DiscordBot(this.discordToken, this.discordChannelId, this, this.logger);
            this.discordBot.start();
        }
        this.logger.info("StaffChat plugin has been enabled!");
    }

    private void loadConfig() {
        try {
            File configDir = this.dataDirectory.toFile();
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File file = new File(configDir, "config.yml");
            Yaml yaml = new Yaml();
            Map defaultConfig = null;
            try (InputStream in = this.getClass().getResourceAsStream("/config.yml");){
                if (in != null) {
                    defaultConfig = (Map)yaml.load(in);
                }
            }
            if (!file.exists()) {
                in = this.getClass().getResourceAsStream("/config.yml");
                try {
                    if (in != null) {
                        Files.copy(in, file.toPath(), new CopyOption[0]);
                        this.logger.info("Created default config.yml");
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            LinkedHashMap userConfig = null;
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                userConfig = (LinkedHashMap)yaml.load(in);
            }
            if (defaultConfig != null) {
                for (String key : defaultConfig.keySet()) {
                    if (userConfig != null && userConfig.containsKey(key)) continue;
                    if (userConfig == null) {
                        userConfig = new LinkedHashMap();
                    }
                    userConfig.put(key, defaultConfig.get(key));
                }
            }
            if (defaultConfig != null) {
                String defaultConfigText = "";
                try (InputStream in = this.getClass().getResourceAsStream("/config.yml");){
                    if (in != null) {
                        defaultConfigText = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                    }
                }
                StringBuilder mergedConfigText = new StringBuilder();
                Pattern pattern = Pattern.compile("^([ \t]*)([a-zA-Z0-9_]+):[ \t]*(.*)$", 8);
                Matcher matcher = pattern.matcher(defaultConfigText);
                int lastEnd = 0;
                while (matcher.find()) {
                    mergedConfigText.append(defaultConfigText, lastEnd, matcher.start());
                    String key = matcher.group(2);
                    Object userVal = userConfig.get(key);
                    Object valueString = userVal instanceof String ? "\"" + ((String)userVal).replace("\"", "\\\"") + "\"" : (userVal != null ? userVal.toString() : matcher.group(3));
                    mergedConfigText.append(matcher.group(1)).append(key).append(": ").append((String)valueString);
                    lastEnd = matcher.end();
                }
                mergedConfigText.append(defaultConfigText.substring(lastEnd));
                try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
                    writer.write(mergedConfigText.toString());
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
                yaml.dump(userConfig, writer);
            }
            this.config = userConfig;
            this.permission = this.getString("permission", "staffchat.use");
            this.prefix = this.getString("prefix", "&8[&4&lSTAFF&8] ");
            this.format = this.getString("format", "&6{player}&7: &f{message}");
            this.discordEnabled = this.getBoolean("discord_enabled", false);
            this.discordToken = this.getString("discord_token", "");
            this.discordChannelId = this.getString("discord_channel_id", "");
            this.discordFormat = this.getString("discord_format", "**[STAFF] {player}:** {message}");
            this.minecraftFormat = this.getString("minecraft_format", "&8[&4&lSTAFF&8][D]&r &b{discord_user}&7: &f{message}");
            this.toggleOnMessage = this.getString("toggle_on_message", "&aStaff chat messages enabled.");
            this.toggleOffMessage = this.getString("toggle_off_message", "&cStaff chat messages disabled.");
            if (this.discordEnabled && !this.discordToken.isEmpty() && !this.discordChannelId.isEmpty()) {
                this.startDiscordBot();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load config.yml", e);
            this.permission = "staffchat.use";
            this.prefix = "&8[&4&lSTAFF&8] ";
            this.format = "&6{player}&7: &f{message}";
            this.discordEnabled = false;
            this.discordToken = "";
            this.discordChannelId = "";
            this.discordFormat = "**[STAFF] {player}:** {message}";
            this.minecraftFormat = "&8[&4&lSTAFF&8][D]&r &b{discord_user}&7: &f{message}";
            this.toggleOnMessage = "&aStaff chat messages enabled.";
            this.toggleOffMessage = "&cStaff chat messages disabled.";
        }
    }

    private String getString(String key, String def) {
        Object val = this.config != null ? this.config.get(key) : null;
        return val instanceof String ? (String)val : def;
    }

    private boolean getBoolean(String key, boolean def) {
        Object val;
        Object object = val = this.config != null ? this.config.get(key) : null;
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        return def;
    }

    private void startDiscordBot() {
    }

    private String colorize(String input) {
        if (input == null) {
            return "";
        }
        String processed = input.replace('\u00a7', '&');
        Pattern hexPattern = Pattern.compile("<#[A-Fa-f0-9]{6}>");
        Matcher matcher = hexPattern.matcher(processed);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group().substring(2, 8);
            StringBuilder adventureHex = new StringBuilder("&x");
            for (char c : hex.toCharArray()) {
                adventureHex.append('&').append(c);
            }
            matcher.appendReplacement(sb, adventureHex.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void registerStaffChatCommand(String commandName) {
        LiteralCommandNode scNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)commandName).requires(source2 -> source2.hasPermission(this.permission))).then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSource source2 = (CommandSource)context.getSource();
            if (!(source2 instanceof Player)) {
                source2.sendMessage(Component.text((String)"Only players can use this command!").color((TextColor)NamedTextColor.RED));
                return 0;
            }
            Player player = (Player)source2;
            String message = (String)context.getArgument("message", String.class);
            String formattedMessage = this.format.replace("{player}", player.getUsername()).replace("{message}", message);
            String colored = this.colorize(this.prefix + formattedMessage);
            TextComponent staffChatMessage = COLOR_SERIALIZER.deserialize(colored);
            for (Player onlinePlayer : this.server.getAllPlayers()) {
                if (!onlinePlayer.hasPermission(this.permission) || this.mutedPlayers.contains(onlinePlayer.getUniqueId())) continue;
                onlinePlayer.sendMessage((Component)staffChatMessage);
            }
            this.logger.info("[STAFF] {}: {}", (Object)player.getUsername(), (Object)message);
            if (this.discordEnabled && this.discordBot != null) {
                String discordMsg = this.discordFormat.replace("{player}", player.getUsername()).replace("{message}", message);
                this.discordBot.sendToDiscord(discordMsg);
            }
            return 1;
        }))).executes(context -> {
            ((CommandSource)context.getSource()).sendMessage(Component.text((String)("Usage: /" + commandName + " <message>")).color((TextColor)NamedTextColor.RED));
            return 0;
        })).build();
        BrigadierCommand scCommand = new BrigadierCommand(scNode);
        this.server.getCommandManager().register(scCommand);
    }

    private void registerToggleCommand() {
        LiteralCommandNode toggleNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"sctoggle").requires(source2 -> source2.hasPermission(this.permission))).executes(context -> {
            CommandSource source2 = (CommandSource)context.getSource();
            if (!(source2 instanceof Player)) {
                source2.sendMessage(Component.text((String)"Only players can use this command!").color((TextColor)NamedTextColor.RED));
                return 0;
            }
            Player player = (Player)source2;
            UUID uuid = player.getUniqueId();
            if (this.mutedPlayers.contains(uuid)) {
                this.mutedPlayers.remove(uuid);
                player.sendMessage((Component)COLOR_SERIALIZER.deserialize(this.colorize(this.toggleOnMessage)));
            } else {
                this.mutedPlayers.add(uuid);
                player.sendMessage((Component)COLOR_SERIALIZER.deserialize(this.colorize(this.toggleOffMessage)));
            }
            return 1;
        })).build();
        BrigadierCommand toggleCommand = new BrigadierCommand(toggleNode);
        this.server.getCommandManager().register(toggleCommand);
    }

    public void handleDiscordMessage(String discordUser, String msg) {
        String mcMsg = this.minecraftFormat.replace("{discord_user}", discordUser).replace("{message}", msg);
        String colored = this.colorize(mcMsg);
        TextComponent mcComponent = COLOR_SERIALIZER.deserialize(colored);
        for (Player p : this.server.getAllPlayers()) {
            if (!p.hasPermission(this.permission) || this.mutedPlayers.contains(p.getUniqueId())) continue;
            p.sendMessage((Component)mcComponent);
        }
    }
}

