/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat;

import de.staffchat.StaffChatPlugin;
import de.staffchat.shaded.jda.api.JDA;
import de.staffchat.shaded.jda.api.JDABuilder;
import de.staffchat.shaded.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import de.staffchat.shaded.jda.api.events.message.MessageReceivedEvent;
import de.staffchat.shaded.jda.api.hooks.ListenerAdapter;
import de.staffchat.shaded.jda.api.requests.GatewayIntent;
import org.slf4j.Logger;

public class DiscordBot
extends ListenerAdapter {
    private JDA jda;
    private final String token;
    private final String channelId;
    private final StaffChatPlugin plugin;
    private final Logger logger;

    public DiscordBot(String token, String channelId, StaffChatPlugin plugin, Logger logger) {
        this.token = token;
        this.channelId = channelId;
        this.plugin = plugin;
        this.logger = logger;
    }

    public void start() {
        new Thread(() -> {
            try {
                this.jda = JDABuilder.createDefault(this.token).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).addEventListeners(this).build();
                this.logger.info("Discord bot started and listening for staff chat messages.");
            }
            catch (Exception e) {
                this.logger.error("Failed to start Discord bot: Invalid token or configuration.", e);
            }
        }, "StaffChat-DiscordBot").start();
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        if (!event.getChannel().getId().equals(this.channelId)) {
            return;
        }
        String discordUser = event.getAuthor().getName();
        Object msg = event.getMessage().getContentStripped();
        if (((String)msg).isEmpty()) {
            if (!event.getMessage().getAttachments().isEmpty()) {
                msg = "[Attachment] " + event.getMessage().getAttachments().get(0).getUrl();
            } else if (!event.getMessage().getEmbeds().isEmpty()) {
                msg = "[Embed]";
            }
        }
        this.logger.info("Discord->MC: '" + (String)msg + "'");
        if (!((String)msg).isEmpty()) {
            this.plugin.handleDiscordMessage(discordUser, (String)msg);
        }
    }

    public void sendToDiscord(String message) {
        StandardGuildMessageChannel channel;
        if (this.jda != null && (channel = this.jda.getChannelById(StandardGuildMessageChannel.class, this.channelId)) != null) {
            channel.sendMessage(message).queue();
        }
    }
}

