/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.managers;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SimpleTeleport plugin;
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public ConfigManager(SimpleTeleport plugin) {
        this.plugin = plugin;
        this.loadConfigs();
    }

    private void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return String.valueOf(ChatColor.RED) + "Message not found: " + path;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessageWithPrefix(String path) {
        return this.getMessage("prefix") + this.getMessage(path);
    }

    public String getMessage(String path, String placeholder, String value) {
        return this.getMessage(path).replace(placeholder, value);
    }

    public void saveMessagesConfig() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages.yml: " + e.getMessage());
        }
    }

    public int getTeleportDelay() {
        return this.config.getInt("teleportation.delay", 3);
    }

    public boolean isCancelOnMove() {
        return this.config.getBoolean("teleportation.cancel-on-move", true);
    }

    public boolean isCancelOnDamage() {
        return this.config.getBoolean("teleportation.cancel-on-damage", true);
    }

    public boolean isCountdownMessages() {
        return this.config.getBoolean("teleportation.countdown-messages", true);
    }

    public int getMaxHomes() {
        return this.config.getInt("homes.max-homes", 1);
    }

    public boolean isTeleportOnFirstJoin() {
        return this.config.getBoolean("spawn.teleport-on-first-join", false);
    }

    public boolean isTeleportOnDeath() {
        return this.config.getBoolean("spawn.teleport-on-death", false);
    }

    public boolean isSaveLocationOnDeath() {
        return this.config.getBoolean("back.save-location-on-death", true);
    }

    public boolean isEconomyEnabled() {
        return this.config.getBoolean("economy.enabled", false);
    }

    public void updateConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        File backupFile = new File(this.plugin.getDataFolder(), "config-old.yml");
        try {
            if (configFile.exists()) {
                YamlConfiguration current = YamlConfiguration.loadConfiguration((File)configFile);
                current.save(backupFile);
            }
            this.plugin.saveResource("config.yml", true);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
            YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)backupFile);
            this.mergeConfigSectionsPreserveUserValues((ConfigurationSection)newConfig, (ConfigurationSection)oldConfig, "");
            newConfig.save(configFile);
            this.plugin.reloadConfig();
            this.config = this.plugin.getConfig();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Config update failed: " + e.getMessage());
        }
    }

    private void mergeConfigSectionsPreserveUserValues(ConfigurationSection newConfig, ConfigurationSection oldConfig, String path) {
        for (String key : newConfig.getKeys(false)) {
            String fullPath = path.isEmpty() ? key : path + "." + key;
            Object newValue = newConfig.get(key);
            Object oldValue = oldConfig.get(key);
            if (newValue instanceof ConfigurationSection) {
                if (!(oldValue instanceof ConfigurationSection)) continue;
                this.mergeConfigSectionsPreserveUserValues((ConfigurationSection)newValue, (ConfigurationSection)oldValue, fullPath);
                continue;
            }
            if (!oldConfig.contains(key)) continue;
            newConfig.set(key, oldValue);
        }
        for (String key : oldConfig.getKeys(false)) {
            if (newConfig.contains(key)) continue;
            newConfig.set(key, oldConfig.get(key));
        }
    }

    public boolean isCooldownEnabled() {
        return this.config.getBoolean("cooldowns.enabled", false);
    }

    public boolean isDebug() {
        return this.config.getBoolean("debug", false);
    }

    public void updateMessages() {
        File backupFile = new File(this.plugin.getDataFolder(), "messages-old.yml");
        try {
            if (this.messagesFile.exists()) {
                YamlConfiguration current = YamlConfiguration.loadConfiguration((File)this.messagesFile);
                current.save(backupFile);
            }
            this.plugin.saveResource("messages.yml", true);
            YamlConfiguration newMessages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            YamlConfiguration oldMessages = YamlConfiguration.loadConfiguration((File)backupFile);
            this.mergeConfigSectionsPreserveUserValues((ConfigurationSection)newMessages, (ConfigurationSection)oldMessages, "");
            newMessages.save(this.messagesFile);
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Messages update failed: " + e.getMessage());
        }
    }

    private void mergeMessagesSections(FileConfiguration newMessages, FileConfiguration oldMessages, String path) {
        for (String key : oldMessages.getKeys(false)) {
            Object fullPath = path.isEmpty() ? key : path + "." + key;
            Object value = oldMessages.get((String)fullPath);
            if (value instanceof ConfigurationSection) {
                this.mergeMessagesSections(newMessages, oldMessages, (String)fullPath);
                continue;
            }
            if (!newMessages.contains((String)fullPath)) continue;
            newMessages.set((String)fullPath, value);
        }
    }
}

