/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public SpawnCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("set")) {
            if (!player.hasPermission("SimpleTeleport.setspawn")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
                return true;
            }
            Location location = player.getLocation();
            this.plugin.getDataManager().setSpawn(location);
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("spawn-set"));
            return true;
        }
        if (!player.hasPermission("SimpleTeleport.spawn")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        Location spawn = this.plugin.getDataManager().getSpawn();
        if (spawn == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("spawn-not-set"));
            return true;
        }
        this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
        player.teleport(spawn);
        player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("spawn-teleport"));
        return true;
    }
}

