/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHomeCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public SetHomeCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.sethome")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        String homeName = "default";
        if (args.length > 0 && !(homeName = args[0].toLowerCase()).matches("^[a-zA-Z0-9_-]{1,16}$")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-name-invalid"));
            return true;
        }
        int maxHomes = this.plugin.getConfigManager().getMaxHomes();
        Location location = player.getLocation();
        boolean success = this.plugin.getDataManager().setHome(player.getUniqueId(), homeName, location, maxHomes);
        if (!success) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-limit-reached"));
            return true;
        }
        String msg = this.plugin.getConfigManager().getMessage("home-set-success", "{name}", homeName);
        player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
        return true;
    }
}

